/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.SLAAccessorService;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class SLAAccessorServiceImpl
implements SLAAccessorService {
    private final SLAFieldManager slaFieldManager;
    private final TimeMetricManager timeMetricManager;
    private final GoalService goalService;

    @Autowired
    public SLAAccessorServiceImpl(SLAFieldManager slaFieldManager, TimeMetricManager timeMetricManager, GoalService goalService) {
        this.slaFieldManager = slaFieldManager;
        this.timeMetricManager = timeMetricManager;
        this.goalService = goalService;
    }

    public Option<com.atlassian.servicedesk.api.sla.metrics.TimeMetric> getTimeMetric(ServiceDesk serviceDesk, int id) {
        return this.timeMetricManager.getTimeMetric(serviceDesk, id).right().toOption().map(t -> t);
    }

    public Option<Goal> getGoal(ApplicationUser user, ServiceDesk serviceDesk, int timeMetricId, int goalId) {
        Either result = Steps.begin(this.timeMetricManager.getTimeMetric(serviceDesk, timeMetricId)).then(timeMetric -> this.goalService.getGoal(user, (TimeMetric)((Object)timeMetric), goalId)).yield((timeMetric, goal) -> goal);
        return result.right().toOption().map(g -> g);
    }

    public Option<CustomField> getSlaCustomField(com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric) {
        return this.slaFieldManager.getById(timeMetric.getCustomFieldId()).right().toOption();
    }
}

