/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.webfragments;

import com.atlassian.servicedesk.internal.api.webfragments.WebInterfaceBeanService;
import com.atlassian.servicedesk.internal.web.contextprovider.ServiceDeskProjectContextProvider;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="{projectKey}/webfragments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WebFragmentResource {
    private final WebInterfaceBeanService webInterfaceBeanService;
    private final ServiceDeskProjectContextProvider contextProvider;

    public WebFragmentResource(WebInterfaceBeanService webInterfaceBeanService, ServiceDeskProjectContextProvider contextProvider) {
        this.webInterfaceBeanService = webInterfaceBeanService;
        this.contextProvider = contextProvider;
    }

    @POST
    @Path(value="sections/{locationKey}")
    public Response getWebSections(@PathParam(value="projectKey") String projectKey, @PathParam(value="locationKey") String locationKey, Map<String, String> context) {
        Map<String, Object> contextMap = this.contextProvider.getContextMap(projectKey);
        contextMap.putAll(context);
        String[] locations = locationKey.split(",");
        ArrayList response = new ArrayList();
        for (String location : locations) {
            response.addAll(this.webInterfaceBeanService.getWebSections(location, contextMap));
        }
        return Response.ok(response).build();
    }

    @POST
    @Path(value="panels/{locationKey}")
    public Response getWebPanels(@PathParam(value="projectKey") String projectKey, @PathParam(value="locationKey") String locationKey, Map<String, String> context) {
        Map<String, Object> contextMap = this.contextProvider.getContextMap(projectKey);
        contextMap.putAll(context);
        String[] locations = locationKey.split(",");
        ArrayList response = new ArrayList();
        for (String location : locations) {
            response.addAll(this.webInterfaceBeanService.getWebPanels(location, contextMap));
        }
        return Response.ok(response).build();
    }
}

