/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.util;

import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class WorkloadPaginationHelper {
    private static final Logger logger = LoggerFactory.getLogger(WorkloadPaginationHelper.class);
    @VisibleForTesting
    public static final String FETCH_BLOCK_SIZE_PROPERTY = "com.atlassian.servicedesk:workload_page_pagination_preferred_fetch_block_size";
    @VisibleForTesting
    public static final String MAXIMUM_PAGES_RANGE_PROPERTY = "com.atlassian.servicedesk:workload_page_pagination_preferred_pages_range";
    @VisibleForTesting
    public static final int DEFAULT_FETCH_BLOCK_SIZE = 50;
    @VisibleForTesting
    public static final int DEFAULT_MAXIMUM_PAGES_RANGE = 5;
    @VisibleForTesting
    public static final int MAXIMUM_AGENT_FETCH_SIZE = 10000;
    private static final int ONE = 1;
    private static final int ZERO = 0;
    private final GlobalPropertyDao globalPropertyDao;

    @Autowired
    public WorkloadPaginationHelper(GlobalPropertyDao globalPropertyDao) {
        this.globalPropertyDao = globalPropertyDao;
    }

    public int getFetchBlockSize() {
        return this.getPropertyValue(FETCH_BLOCK_SIZE_PROPERTY, 50);
    }

    public int getMaximumPagesToShow() {
        return this.getPropertyValue(MAXIMUM_PAGES_RANGE_PROPERTY, 5);
    }

    public LimitedPagedRequest createSearchPageRequest(int pageNumber, int blockSize) {
        int start = this.calculateStart(pageNumber, blockSize);
        int limit = blockSize;
        return LimitedPagedRequestImpl.create((int)start, (int)limit, (int)10000);
    }

    @VisibleForTesting
    int getPropertyValue(String key, int defaultValue) {
        Long blockSize;
        try {
            blockSize = this.globalPropertyDao.getLongProperty(key);
        }
        catch (Exception e) {
            logger.info("Failed while retrieving {}. Returning default", (Object)key);
            logger.debug("Stacktrace", (Throwable)e);
            return defaultValue;
        }
        if (blockSize == null) {
            blockSize = defaultValue;
            try {
                this.globalPropertyDao.setLongProperty(key, blockSize);
            }
            catch (Exception e) {
                logger.info("Failed while setting {} to default", (Object)key);
                logger.debug("Stacktrace", (Throwable)e);
            }
        }
        int value = (int)Math.min(Integer.MAX_VALUE, blockSize);
        return Math.max(1, value);
    }

    private int calculateStart(int pageNumber, int blockSize) {
        return Math.max(0, pageNumber - 1) * blockSize;
    }
}

