/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.util;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarManager;
import com.atlassian.servicedesk.internal.feature.customer.search.CustomerSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.OrganizationSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UserSearchItemResult;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.feature.organization.jql.OrganisationJQLHelper;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerPageOrganisationResponse;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerPageResponseItem;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerPageUserResponse;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerResultsResponse;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponse;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponseImpl;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class UserAndOrgPaginationHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserAndOrgPaginationHelper.class);
    @VisibleForTesting
    public static final String FETCH_BLOCK_SIZE_PROPERTY = "com.atlassian.servicedesk:customers_page_pagination_preferred_fetch_block_size";
    @VisibleForTesting
    public static final String MAXIMUM_PAGES_RANGE_PROPERTY = "com.atlassian.servicedesk:customers_page_pagination_preferred_pages_range";
    @VisibleForTesting
    public static final int DEFAULT_FETCH_BLOCK_SIZE = 50;
    @VisibleForTesting
    public static final int DEFAULT_MAXIMUM_PAGES_RANGE = 5;
    private static final int MAXIMUM_CUSTOMER_FETCH_SIZE = 10000;
    private static final int ONE = 1;
    private static final int ZERO = 0;
    private final ApplicationProperties applicationProperties;
    private final ServiceDeskIssueService serviceDeskIssueService;
    private final GlobalPropertyDao globalPropertyDao;
    private final SDAgentAvatarManager agentAvatarManager;
    private final OrganisationJQLHelper organisationJQLHelper;
    private final FeatureManager featureManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;

    @Autowired
    public UserAndOrgPaginationHelper(ApplicationProperties applicationProperties, ServiceDeskIssueService serviceDeskIssueService, GlobalPropertyDao globalPropertyDao, SDAgentAvatarManager agentAvatarManager, OrganisationJQLHelper organisationJQLHelper, FeatureManager featureManager, ServiceDeskPermissions serviceDeskPermissions, CustomerOrganizationMemberManager customerOrganizationMemberManager) {
        this.applicationProperties = applicationProperties;
        this.serviceDeskIssueService = serviceDeskIssueService;
        this.globalPropertyDao = globalPropertyDao;
        this.agentAvatarManager = agentAvatarManager;
        this.organisationJQLHelper = organisationJQLHelper;
        this.featureManager = featureManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
    }

    public int getFetchBlockSize() {
        return this.getPropertyValue(FETCH_BLOCK_SIZE_PROPERTY, 50);
    }

    public int getMaximumPagesToShow() {
        return this.getPropertyValue(MAXIMUM_PAGES_RANGE_PROPERTY, 5);
    }

    public Option<CustomerResultsResponse> checkPageNumberRequest(CheckedUser user, int pageNumber, String query, Project project, int blockSize, int maxPages) {
        if (pageNumber < 1) {
            String error = user.i18NHelper().getText("sd.agent.customer.page.error.pagenumber.less");
            return Option.some((Object)this.createCustomerResultsResponse(user, query, pageNumber, project, LazyPagedResponseImpl.from(PagedResponseImpl.empty((boolean)false)), blockSize, maxPages, (Option<String>)Option.some((Object)error), false));
        }
        return Option.none();
    }

    public LimitedPagedRequest createSearchPageRequest(int pageNumber, int blockSize, int maxPages) {
        int start = this.calculateStart(pageNumber, blockSize);
        int limit = this.calculateLimit(start, blockSize, maxPages);
        return LimitedPagedRequestImpl.create((int)start, (int)limit, (int)10000);
    }

    public CustomerResultsResponse createCustomerResultsResponse(CheckedUser user, String query, int pageNumber, Project project, LazyPagedResponse<CustomerSearchItemResult> pagedResponse, int blockSize, int maxPages, Option<String> error, boolean showUserOrgs) {
        int total = pagedResponse.total();
        boolean totalDetermined = !pagedResponse.hasNextPage();
        int lastPage = (int)Math.ceil((double)total / (double)blockSize) + (totalDetermined ? 0 : 1);
        return (CustomerResultsResponse)error.orElse(() -> {
            if (pageNumber > 1 && pagedResponse.size() < 1) {
                return Option.some((Object)user.i18NHelper().getText("sd.agent.customer.page.not.enough.customers"));
            }
            return Option.none();
        }).fold(() -> new CustomerResultsResponse(this.createCustomerAndOrganisationResponses(user, pagedResponse, project, blockSize, showUserOrgs), query, (long)total, pageNumber, lastPage, totalDetermined, blockSize, maxPages), msg -> new CustomerResultsResponse((String)msg, query, (long)total, pageNumber, lastPage, totalDetermined, blockSize, maxPages));
    }

    public CustomerPageResponseItem toPageResponseItem(CheckedUser executedUser, CustomerSearchItemResult searchItemResult, Project project, boolean showUserOrgs) {
        switch (searchItemResult.getType()) {
            case USER: {
                return this.convertToCustomerUserResponse(executedUser, (UserSearchItemResult)searchItemResult, project, showUserOrgs);
            }
            case ORGANISATION: {
                return this.convertToOrganisationResponse(executedUser, (OrganizationSearchItemResult)searchItemResult, project);
            }
        }
        throw new IllegalStateException("Unsupported CustomerSearchItemResult type");
    }

    public List<CustomerPageResponseItem> createCustomerAndOrganisationResponses(CheckedUser user, LazyPagedResponse<CustomerSearchItemResult> pagedResponse, Project project, int blockSize, boolean showUserOrgs) {
        List responseList = pagedResponse.getResults();
        List results = responseList.subList(0, this.minBlockLimit(responseList, blockSize));
        return results.stream().map(result -> this.toPageResponseItem(user, (CustomerSearchItemResult)result, project, showUserOrgs)).collect(Collectors.toList());
    }

    @VisibleForTesting
    int getPropertyValue(String key, int defaultValue) {
        Long blockSize;
        try {
            blockSize = this.globalPropertyDao.getLongProperty(key);
        }
        catch (Exception e) {
            logger.info("Failed while retrieving {}. Returning default", (Object)key);
            logger.debug("Stacktrace", (Throwable)e);
            return defaultValue;
        }
        if (blockSize == null) {
            blockSize = defaultValue;
            try {
                this.globalPropertyDao.setLongProperty(key, blockSize);
            }
            catch (Exception e) {
                logger.info("Failed while setting {} to default", (Object)key);
                logger.debug("Stacktrace", (Throwable)e);
            }
        }
        int value = (int)Math.min(Integer.MAX_VALUE, blockSize);
        return Math.max(1, value);
    }

    private CustomerPageOrganisationResponse convertToOrganisationResponse(CheckedUser executedUser, OrganizationSearchItemResult organizationSearchItemResult, Project project) {
        String openedRequestJql;
        String closedRequestJql;
        CustomerOrganization organisation = organizationSearchItemResult.getValue();
        long closedRequestCount = this.organisationJQLHelper.countClosedRequest(executedUser, organisation, project);
        long openedRequestCount = this.organisationJQLHelper.countOpenedRequest(executedUser, organisation, project);
        try {
            closedRequestJql = URLEncoder.encode(this.organisationJQLHelper.getClosedRequestJql(organisation, project), this.applicationProperties.getEncoding());
            openedRequestJql = URLEncoder.encode(this.organisationJQLHelper.getOpenedRequestJql(organisation, project), this.applicationProperties.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Encoding error while processing JQL customer requests", (Throwable)e);
            throw new IllegalStateException(e);
        }
        return new CustomerPageOrganisationResponse(organisation.getId(), organisation.getName(), openedRequestCount, openedRequestJql, closedRequestCount, closedRequestJql);
    }

    private CustomerPageUserResponse convertToCustomerUserResponse(CheckedUser executedUser, UserSearchItemResult userSearchItemResult, Project project, boolean showUserOrgs) {
        CheckedUser customer = userSearchItemResult.getValue();
        CustomerPageUserResponse response = new CustomerPageUserResponse();
        response.setIdentifier(customer.getKey());
        response.setName(customer.getName());
        response.setDisplayName(customer.getDisplayName());
        response.setEmail(customer.getEmailAddress());
        response.setAgent(this.serviceDeskPermissions.canViewAgentView((SDUser)customer, project));
        response.setOpenRequestCount(this.serviceDeskIssueService.countUnresolvedForReporter(executedUser, customer, project));
        response.setClosedRequestCount(this.serviceDeskIssueService.countResolvedForReporter(executedUser, customer, project));
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            response.setAvatarUrl(this.agentAvatarManager.processAvatarRequest(customer.forJIRA(), Avatar.Size.MEDIUM));
            if (showUserOrgs) {
                response.setOrganisationNames(this.getOrganisationNamesForUser(customer, project));
            }
        }
        try {
            response.setOpenRequestsJql(URLEncoder.encode(this.serviceDeskIssueService.getUnresolvedForReporterJql(executedUser, customer, project), this.applicationProperties.getEncoding()));
            response.setClosedRequestsJql(URLEncoder.encode(this.serviceDeskIssueService.getResolvedForReporterJql(executedUser, customer, project), this.applicationProperties.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Encoding error while processing JQL customer requests", (Throwable)e);
            throw new RuntimeException(e);
        }
        return response;
    }

    private Set<String> getOrganisationNamesForUser(CheckedUser user, Project project) {
        Collection organisationsForUser = (Collection)this.customerOrganizationMemberManager.getUserOrganizationsInProject(user, project).getOrElse(Collections.emptyList());
        return CustomerOrganizationUtil.transformToNames(organisationsForUser);
    }

    private int calculateLimit(int start, int blockSize, int maxPages) {
        long initialPreferred = Math.max(1, maxPages) * Math.max(1, blockSize);
        if ((long)start < initialPreferred) {
            return (int)(initialPreferred - (long)start);
        }
        return blockSize;
    }

    private int calculateStart(int pageNumber, int blockSize) {
        return Math.max(0, pageNumber - 1) * blockSize;
    }

    private <T> int minBlockLimit(List<T> responseList, int blockSize) {
        return Math.min(blockSize, responseList.size());
    }
}

