/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.temporary;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CustomerPortalPermissionsUtil {
    private final GlobalPermissionManager globalPermissionManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public CustomerPortalPermissionsUtil(GlobalPermissionManager globalPermissionManager, ErrorResultHelper errorResultHelper) {
        this.globalPermissionManager = globalPermissionManager;
        this.errorResultHelper = errorResultHelper;
    }

    Either<AnError, Unit> canUseResource(ApplicationUser user) {
        if (!this.hasPermission(user)) {
            AnError anError = this.errorResultHelper.anError(403, "Only sysadmin and site admins can execute this resource", new Object[0]);
            return Either.left((Object)anError);
        }
        return Either.right((Object)Unit.UNIT);
    }

    private boolean hasPermission(ApplicationUser user) {
        return this.isSysAdmin(user) || this.isSiteAdmin(user);
    }

    private boolean isSysAdmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    private boolean isSiteAdmin(ApplicationUser user) {
        return this.isJIRAAdmin(user);
    }

    private boolean isJIRAAdmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

