/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.temporary;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonAutoDetect;

class CustomerPortalPermissionsResourceUtil {
    CustomerPortalPermissionsResourceUtil() {
    }

    public static int getAffectedUserCount(Map<Project, Set<ApplicationUser>> map) {
        HashSet allUsers = new HashSet();
        map.values().forEach(allUsers::addAll);
        return allUsers.size();
    }

    public static int getAffectedProjectCount(Map<Project, Set<ApplicationUser>> map) {
        return map.values().stream().filter(e -> !e.isEmpty()).collect(Collectors.toList()).size();
    }

    public static Result toResult(Map<Project, Set<ApplicationUser>> data, boolean includeNonAnonymousData) {
        HashSet<ApplicationUser> affectedUsers = new HashSet<ApplicationUser>();
        HashSet<Project> affectedProjects = new HashSet<Project>();
        ArrayList<ProjectResult> perProject = new ArrayList<ProjectResult>();
        data.entrySet().forEach(e -> {
            Project project = (Project)e.getKey();
            Set users = (Set)e.getValue();
            if (!users.isEmpty()) {
                affectedProjects.add(project);
                affectedUsers.addAll(users);
            }
            ProjectResult simpleProjectResult = new ProjectResult(project, users, includeNonAnonymousData);
            perProject.add(simpleProjectResult);
        });
        return new Result(perProject, affectedUsers, affectedProjects, includeNonAnonymousData);
    }

    @JsonAutoDetect
    public static class ProjectResult {
        private long projectId;
        private int numberOfUsers;
        private String projectKey = null;
        private List<String> users = null;

        ProjectResult(Project project, Set<ApplicationUser> users, boolean includeNonAnonymousData) {
            this.projectId = project.getId();
            this.numberOfUsers = users.size();
            if (includeNonAnonymousData) {
                this.users = users.stream().map(ApplicationUser::getKey).collect(Collectors.toList());
                Collections.sort(this.users);
                this.projectKey = project.getKey();
            }
        }

        public long getProjectId() {
            return this.projectId;
        }

        public int getNumberOfUsers() {
            return this.numberOfUsers;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public List<String> getUsers() {
            return this.users;
        }
    }

    @JsonAutoDetect
    public static class Result {
        private List<ProjectResult> results;
        private int affectedUserCount;
        private int affectedProjectCount;
        private List<String> affectedUsers = null;
        private List<String> affectedProjects = null;

        public Result(List<ProjectResult> results, Set<ApplicationUser> affectedUsers, Set<Project> affectedProjects, boolean includeNonAnonymousData) {
            this.results = results;
            this.affectedUserCount = affectedUsers.size();
            this.affectedProjectCount = affectedProjects.size();
            if (includeNonAnonymousData) {
                this.affectedUsers = affectedUsers.stream().map(ApplicationUser::getName).collect(Collectors.toList());
                Collections.sort(this.affectedUsers);
                this.affectedProjects = affectedProjects.stream().map(Project::getKey).collect(Collectors.toList());
                Collections.sort(this.affectedProjects);
            }
        }

        public List<ProjectResult> getResults() {
            return this.results;
        }

        public int getAffectedUserCount() {
            return this.affectedUserCount;
        }

        public int getAffectedProjectCount() {
            return this.affectedProjectCount;
        }

        public List<String> getAffectedUsers() {
            return this.affectedUsers;
        }

        public List<String> getAffectedProjects() {
            return this.affectedProjects;
        }
    }
}

