/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.temporary;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.rest.temporary.CustomerPortalPermissionsUtil;
import com.google.common.base.Predicate;
import io.atlassian.fugue.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CustomerPortalPermissionsConfigurationCheckService {
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final ProjectManager projectManager;
    private final UserSearchManager userSearchManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final CustomerContextService customerContextService;
    private final CustomerPortalPermissionsUtil customerPortalPermissionUtil;

    @Autowired
    public CustomerPortalPermissionsConfigurationCheckService(ServiceDeskInternalManager serviceDeskInternalManager, ProjectManager projectManager, UserSearchManager userSearchManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, CustomerContextService customerContextService, CustomerPortalPermissionsUtil customerPortalPermissionUtil) {
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.projectManager = projectManager;
        this.userSearchManager = userSearchManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.customerContextService = customerContextService;
        this.customerPortalPermissionUtil = customerPortalPermissionUtil;
    }

    Either<AnError, Map<Project, Set<ApplicationUser>>> findNonCreateCustomersPerServiceDeskProject(ApplicationUser user) {
        Either<AnError, Unit> permCheck = this.customerPortalPermissionUtil.canUseResource(user);
        if (permCheck.isLeft()) {
            return Either.left((Object)permCheck.left().get());
        }
        NoExceptionsCallable callable = this::findNonCreateCustomersPerServiceDeskProjectImpl;
        Map result = (Map)this.customerContextService.runInCustomerContext(callable);
        return Either.right((Object)result);
    }

    private Map<Project, Set<ApplicationUser>> findNonCreateCustomersPerServiceDeskProjectImpl() {
        HashMap<Project, Set<ApplicationUser>> usersPerProject = new HashMap<Project, Set<ApplicationUser>>();
        List<ServiceDesk> allEnabledServiceDesks = this.serviceDeskInternalManager.getAllEnabledServiceDesks();
        for (ServiceDesk serviceDesk : allEnabledServiceDesks) {
            Project project = this.projectManager.getProjectObj(Long.valueOf(serviceDesk.getProjectId()));
            if (project == null) continue;
            Set<ApplicationUser> usersWithoutCreate = this.findUsersWithoutCreate(project);
            usersPerProject.put(project, usersWithoutCreate);
        }
        return usersPerProject;
    }

    private Set<ApplicationUser> findUsersWithoutCreate(Project project) {
        UserSearchParams userSearchParams = UserSearchParams.builder().allowEmptyQuery(true).includeActive(true).includeInactive(false).maxResults(null).filter(this.getAffectedUserPredicate(project)).build();
        Stream search = this.userSearchManager.search("", userSearchParams);
        return search.collect(Collectors.toSet());
    }

    private Predicate<User> getAffectedUserPredicate(Project project) {
        return user -> this.isAffectedUser(project, ApplicationUsers.from((User)user));
    }

    private boolean isAffectedUser(Project project, ApplicationUser user) {
        if (user == null) {
            return false;
        }
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
            return false;
        }
        boolean hasBrowsePermission = this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user);
        if (!hasBrowsePermission) {
            return false;
        }
        boolean hasCreatePermission = this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, user);
        return !hasCreatePermission;
    }
}

