/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.supportinfo;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.CronScheduleInfo;
import com.atlassian.scheduler.config.IntervalScheduleInfo;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.supportinfo.AtlassianSchedulerJobState;
import com.atlassian.servicedesk.internal.rest.supportinfo.AtlassianSchedulerStateResponse;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="supportinfo/atlassian-scheduler")
public class AtlassianSchedulerStateResource {
    private final SchedulerService schedulerService;
    private final RestResponseHelper restResponseHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public AtlassianSchedulerStateResource(SchedulerService scheduledService, RestResponseHelper restResponseHelper, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, ErrorResultHelper errorResultHelper) {
        this.schedulerService = scheduledService;
        this.restResponseHelper = restResponseHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.errorResultHelper = errorResultHelper;
    }

    @GET
    public Response schedulerState() {
        if (!this.hasPermission()) {
            return this.restResponseHelper.anErrorToResponse(this.errorResultHelper.forbidden403("Permission denied", new Object[0]).build());
        }
        Set jobRunnerKeys = this.schedulerService.getJobRunnerKeysForAllScheduledJobs();
        List<AtlassianSchedulerJobState> jobStates = this.getJobDetailsForAllRunners(jobRunnerKeys);
        return this.restResponseHelper.ok((Object)new AtlassianSchedulerStateResponse(jobRunnerKeys.size(), jobStates.size(), jobStates));
    }

    private List<AtlassianSchedulerJobState> getJobDetailsForAllRunners(Set<JobRunnerKey> jobRunnerKeys) {
        return jobRunnerKeys.stream().map(arg_0 -> ((SchedulerService)this.schedulerService).getJobsByJobRunnerKey(arg_0)).flatMap(this::getAllJobDetails).collect(Collectors.toList());
    }

    private Stream<AtlassianSchedulerJobState> getAllJobDetails(List<JobDetails> jobDetailsList) {
        return jobDetailsList.stream().map(this::buildSchedulerStateResponse);
    }

    private AtlassianSchedulerJobState buildSchedulerStateResponse(JobDetails jobDetails) {
        return new AtlassianSchedulerJobState(jobDetails.getJobId().toString(), jobDetails.getJobRunnerKey().toString(), jobDetails.getRunMode().toString(), jobDetails.getNextRunTime().toInstant().toEpochMilli(), this.getInterval(jobDetails), this.getSchedule(jobDetails));
    }

    private boolean hasPermission() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    private Long getInterval(JobDetails jobDetails) {
        IntervalScheduleInfo intervalSchedule = jobDetails.getSchedule().getIntervalScheduleInfo();
        if (intervalSchedule == null) {
            return null;
        }
        return intervalSchedule.getIntervalInMillis();
    }

    private String getSchedule(JobDetails jobDetails) {
        CronScheduleInfo cronSchedule = jobDetails.getSchedule().getCronScheduleInfo();
        if (cronSchedule == null) {
            return "";
        }
        return cronSchedule.getCronExpression();
    }
}

