/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.debug.response;

import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

public class DebugTimeline {
    @JsonProperty(value="events")
    public List<DebugTimelineEvent> events = Lists.newArrayList();

    public static DebugTimeline from(Timeline timeline) {
        DebugTimeline result = new DebugTimeline();
        for (TimelineEvent event : timeline.getEvents()) {
            result.events.add(DebugTimeline.from(event));
        }
        return result;
    }

    public static DebugTimelineEvent from(TimelineEvent event) {
        DebugTimelineEvent result = new DebugTimelineEvent();
        result.date = event.getDate();
        result.dateString = event.getDate().toString();
        result.types = event.getTypes();
        return result;
    }

    public static class DebugTimelineEvent {
        @JsonProperty
        public DateTime date;
        @JsonProperty
        public String dateString;
        @JsonProperty
        public EnumSet<TimelineEventType> types;
    }
}

