/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.debug;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.rest.sla.ConditionResource;
import com.atlassian.servicedesk.internal.rest.sla.TimeMetricDefinitionResource;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.AbstractDebugResponseData;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugCompleteSlaConfigurationData;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugConditionHistory;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugConditionResult;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugCustomField;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugGoalData;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugOutdatedMetricData;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugSLAValue;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugTimeMetricData;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricDefinitionResponse;
import com.atlassian.servicedesk.internal.sla.condition.ConditionFactoryService;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricHitConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricMatchConditionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionService;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefManager;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLACFType;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import com.atlassian.servicedesk.internal.sla.customfield.SLAValueSerializer;
import com.atlassian.servicedesk.internal.sla.goal.GoalMatcher;
import com.atlassian.servicedesk.internal.sla.goal.IssueIndexingContext;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractor;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.task.OutdatedIssueFinder;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/servicedesk/{projectKey}/sla/debug")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SlaDebugResource {
    String SLA_CFTYPE_FULL_KEY = "com.atlassian.servicedesk:sd-sla-field";
    private static final SLAValueSerializer SERIALIZER = new SLAValueSerializer();
    private final InternalServiceDeskService serviceDeskService;
    private final OutdatedIssueFinder outdatedIssueFinder;
    private final PermissionService permissionService;
    private final GlobalPermissionManager globalPermissionManager;
    private final IssueService issueService;
    private final InternalTimeMetricService timeMetricService;
    private final SLAFieldService slaFieldService;
    private final MetricStateHistoryExtractor metricStateHistoryExtractor;
    private final TimeMetricDefinitionService timeMetricDefinitionService;
    private final GoalService goalService;
    private final CustomFieldManager customFieldManager;
    private final MetricConditionRefManager metricConditionRefManager;
    private final GoalMatcher goalMatcher;
    private final ConditionFactoryService conditionFactoryService;
    private final ProjectService projectService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;

    protected SlaDebugResource(InternalServiceDeskService serviceDeskService, OutdatedIssueFinder outdatedIssueFinder, PermissionService permissionService, GlobalPermissionManager globalPermissionManager, IssueService issueService, InternalTimeMetricService timeMetricService, SLAFieldService slaFieldService, MetricStateHistoryExtractor metricStateHistoryExtractor, TimeMetricDefinitionService timeMetricDefinitionService, GoalService goalService, CustomFieldManager customFieldManager, MetricConditionRefManager metricConditionRefManager, GoalMatcher goalMatcher, ConditionFactoryService conditionFactoryService, ProjectService projectService, UserFactory userFactory, RestResponseHelper restResponseHelper) {
        this.serviceDeskService = serviceDeskService;
        this.outdatedIssueFinder = outdatedIssueFinder;
        this.permissionService = permissionService;
        this.globalPermissionManager = globalPermissionManager;
        this.issueService = issueService;
        this.timeMetricService = timeMetricService;
        this.slaFieldService = slaFieldService;
        this.metricStateHistoryExtractor = metricStateHistoryExtractor;
        this.timeMetricDefinitionService = timeMetricDefinitionService;
        this.goalService = goalService;
        this.customFieldManager = customFieldManager;
        this.metricConditionRefManager = metricConditionRefManager;
        this.goalMatcher = goalMatcher;
        this.conditionFactoryService = conditionFactoryService;
        this.projectService = projectService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="/outdated")
    public Response getOutdatedIssuesInfos(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapToValidationErrors("No service desk or permission", this.getServiceDeskAndCheckPermission(projectKey))).yield(serviceDesk -> {
            ApplicationUser user = this.userFactory.getUncheckedUser().forJIRA();
            long serviceDeskIssueCount = this.outdatedIssueFinder.getServiceDeskIssueCount((ServiceDesk)serviceDesk);
            List<String> outdatedIssuesKeys = this.outdatedIssueFinder.findOutdatedIssuesKeys(user, (ServiceDesk)serviceDesk, -1);
            DebugOutdatedMetricData data = new DebugOutdatedMetricData();
            this.setDebugInfo(user, data, (ServiceDesk)serviceDesk);
            data.totalIssuesCount = serviceDeskIssueCount;
            data.outdatedIssueCount = outdatedIssuesKeys.size();
            data.outdatedIssuesKeys = outdatedIssuesKeys;
            return data;
        });
        return this.restResponseHelper.validationErrorsEitherToOkResponse(result);
    }

    @GET
    @Path(value="/issue/{issueKey}/metric/{metricId}/data")
    public Response getCurrentSlaValue(@PathParam(value="projectKey") String projectKey, @PathParam(value="issueKey") String issueKey, @PathParam(value="metricId") int metricId) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapToValidationErrors("No service desk or permission", this.getServiceDeskAndCheckPermission(projectKey))).then(serviceDesk -> {
            IssueService.IssueResult issueResult = this.issueService.getIssue(user.forJIRA(), issueKey);
            if (issueResult.isValid()) {
                return io.atlassian.fugue.Either.right((Object)issueResult.getIssue());
            }
            return this.leftMapToValidationErrors("Could not fetch issue", io.atlassian.fugue.Either.left((Object)issueResult.getErrorCollection()));
        }).then((serviceDesk, mutableIssue) -> this.leftMapToValidationErrors("Could not fetch metric", this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId))).then((serviceDesk, mutableIssue, timeMetric) -> this.leftMapToValidationErrors("Could not fetch SLA customfield", this.slaFieldService.getById(user.forJIRA(), timeMetric.getCustomFieldId()))).yield((serviceDesk, mutableIssue, timeMetric, customField) -> this.loadSlaValueForIssue((Issue)mutableIssue, (CustomField)customField));
        return this.restResponseHelper.validationErrorsEitherToOkResponse(result.map(SERIALIZER::serialize));
    }

    private DebugSLAValue loadSlaValueForIssue(Issue issue, CustomField customField) {
        SLACFType slacfTyple = (SLACFType)this.customFieldManager.getCustomFieldType(this.SLA_CFTYPE_FULL_KEY);
        List<Object> dbValue = slacfTyple.getRawSlaFieldValue(customField, issue);
        if (dbValue == null || dbValue.isEmpty()) {
            return DebugSLAValue.fromInvalid("No value set", null, customField.getIdAsLong(), customField.getFieldName());
        }
        if (dbValue.size() > 1) {
            return DebugSLAValue.fromInvalid("More than one value stored in db", dbValue.toString(), customField.getIdAsLong(), customField.getFieldName());
        }
        Object object = dbValue.get(0);
        if (!(object instanceof String)) {
            return DebugSLAValue.fromInvalid("Database value of invalid type", object.toString(), customField.getIdAsLong(), customField.getFieldName());
        }
        String slaValueString = (String)object;
        SLAValue slaValue = SERIALIZER.unserialize(slaValueString);
        if (slaValue == null) {
            return DebugSLAValue.fromInvalid("Deserialization failed", slaValueString, customField.getIdAsLong(), customField.getFieldName());
        }
        return DebugSLAValue.from(slaValue, customField.getIdAsLong(), customField.getFieldName());
    }

    @GET
    @Path(value="/issue/{issueKey}/metric/{metricId}/data/calculated")
    public Response getCalculatedSlaValue(@PathParam(value="projectKey") String projectKey, @PathParam(value="issueKey") String issueKey, @PathParam(value="metricId") int metricId) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapToValidationErrors("No service desk or permission", this.getServiceDeskAndCheckPermission(projectKey))).then(serviceDesk -> {
            IssueService.IssueResult issueResult = this.issueService.getIssue(user.forJIRA(), issueKey);
            if (issueResult.isValid()) {
                return io.atlassian.fugue.Either.right((Object)issueResult.getIssue());
            }
            return this.leftMapToValidationErrors("Could not fetch issue", io.atlassian.fugue.Either.left((Object)issueResult.getErrorCollection()));
        }).then((serviceDesk, mutableIssue) -> this.leftMapToValidationErrors("Could not fetch metric", this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId))).yield((serviceDesk, mutableIssue, timeMetric) -> {
            List<MetricConditionRef> conditions = this.metricConditionRefManager.getMetricConditions((TimeMetric)((Object)timeMetric));
            Goal goal = this.goalMatcher.getMatchingGoal((Issue)mutableIssue, (TimeMetric)((Object)timeMetric), IssueIndexingContext.noIndexing());
            SLAValue slaValue = this.metricStateHistoryExtractor.calculateSLAValueForSpecialDebugAndAdminPurposes((Issue)mutableIssue, (TimeMetric)((Object)timeMetric), conditions, goal, DateTime.now());
            return DebugSLAValue.from(slaValue, timeMetric.getCustomFieldId(), timeMetric.getName());
        });
        return this.restResponseHelper.validationErrorsEitherToOkResponse(result.map(SERIALIZER::serialize));
    }

    @GET
    @Path(value="/configuration")
    public Response getConfiguration(@PathParam(value="projectKey") String projectKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapToValidationErrors("No service desk or permission", this.getServiceDeskAndCheckPermission(projectKey))).then(serviceDesk -> this.leftMapToValidationErrors("Cannot fetch fields", this.slaFieldService.getAll(user.forJIRA()))).yield((serviceDesk, allFields) -> {
            ArrayList unassignedFields = Lists.newArrayList((Iterable)allFields);
            List<TimeMetric> timeMetrics = this.timeMetricService.getTimeMetrics(user.forJIRA(), (ServiceDesk)serviceDesk);
            ArrayList debugMetrics = Lists.newArrayList();
            for (TimeMetric timeMetric : timeMetrics) {
                CustomField field = this.findInList((List<CustomField>)allFields, timeMetric.getCustomFieldId());
                if (field != null) {
                    unassignedFields.remove(field);
                }
                TimeMetricDefinitionInfo timeMetricDefinition = this.timeMetricDefinitionService.loadDefinitionConfiguration(user.forJIRA(), timeMetric);
                I18nHelper i18nHelper = user.i18NHelper();
                TimeMetricDefinitionResponse definition = TimeMetricDefinitionResource.from(i18nHelper, timeMetricDefinition);
                List<Goal> goals = this.goalService.getAllByTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, timeMetric);
                List<DebugGoalData> goalData = this.fromGoalsList(goals);
                debugMetrics.add(DebugTimeMetricData.from(timeMetric, field, definition, goalData));
            }
            DebugCompleteSlaConfigurationData data = new DebugCompleteSlaConfigurationData();
            this.setDebugInfo(user.forJIRA(), data, (ServiceDesk)serviceDesk);
            data.metrics = debugMetrics;
            data.unmappedFields = this.fromCustomFieldList(unassignedFields);
            return data;
        });
        return this.restResponseHelper.validationErrorsEitherToOkResponse(result);
    }

    @GET
    @Path(value="/issue/{issueKey}/condition/{pluginKey}/{factoryKey}/{conditionId}")
    public Response getHistoryForCondition(@PathParam(value="projectKey") String projectKey, @PathParam(value="issueKey") String issueKey, @PathParam(value="pluginKey") String pluginKey, @PathParam(value="factoryKey") String factoryKey, @PathParam(value="conditionId") String conditionId) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either response = Steps.begin(this.leftMapErrorCollectionResponse("No service desk or permission", this.getServiceDeskAndCheckPermission(projectKey))).then(serviceDesk -> {
            IssueService.IssueResult issueResult = this.issueService.getIssue(user.forJIRA(), issueKey);
            if (issueResult.isValid()) {
                return io.atlassian.fugue.Either.right((Object)issueResult.getIssue());
            }
            return this.leftMapErrorCollectionResponse("Could not fetch issue", io.atlassian.fugue.Either.left((Object)issueResult.getErrorCollection()));
        }).then((serviceDesk, mutableIssue) -> {
            TimeMetricHitConditionInfo hitCondition = this.conditionFactoryService.getHitCondition(pluginKey, factoryKey, conditionId);
            TimeMetricMatchConditionInfo matchCondition = this.conditionFactoryService.getMatchCondition(pluginKey, factoryKey, conditionId);
            if (!hitCondition.isComplete() && !matchCondition.isComplete()) {
                return io.atlassian.fugue.Either.left((Object)this.restResponseHelper.badRequest("No condition with given pluginKey, factoryKey and conditionId found"));
            }
            return io.atlassian.fugue.Either.right((Object)Pair.pair((Object)hitCondition, (Object)matchCondition));
        }).yield((serviceDesk, mutableIssue, conditionPair) -> {
            HitConditionHistory history;
            TimeMetricHitConditionInfo hitCondition = (TimeMetricHitConditionInfo)conditionPair.left();
            TimeMetricMatchConditionInfo matchCondition = (TimeMetricMatchConditionInfo)conditionPair.right();
            I18nHelper i18nHelper = user.i18NHelper();
            DebugConditionResult result = new DebugConditionResult();
            if (hitCondition.isComplete()) {
                history = ((TimeMetricHitCondition)hitCondition.getCondition()).getHistory((Issue)mutableIssue);
                result.hitCondition = new DebugConditionResult.ConditionData();
                result.hitCondition.info = ConditionResource.from(i18nHelper, hitCondition);
                result.hitCondition.history = DebugConditionHistory.from(history);
            }
            if (matchCondition.isComplete()) {
                history = ((TimeMetricMatchCondition)matchCondition.getCondition()).getHistory((Issue)mutableIssue);
                result.matchCondition = new DebugConditionResult.ConditionData();
                result.matchCondition.info = ConditionResource.from(i18nHelper, matchCondition);
                result.matchCondition.history = DebugConditionHistory.from((MatchConditionHistory)history);
            }
            return result;
        });
        return (Response)Eithers.merge((io.atlassian.fugue.Either)response.map(arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0)));
    }

    @GET
    @Path(value="/issue/{issueKey}/metric/{metricId}/conditions")
    public Response getHistoryForCondition(@PathParam(value="projectKey") String projectKey, @PathParam(value="issueKey") String issueKey, @PathParam(value="metricId") int metricId) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either response = Steps.begin(this.leftMapToValidationErrors("No service desk or permission", this.getServiceDeskAndCheckPermission(projectKey))).then(serviceDesk -> {
            IssueService.IssueResult issueResult = this.issueService.getIssue(user.forJIRA(), issueKey);
            if (issueResult.isValid()) {
                return io.atlassian.fugue.Either.right((Object)issueResult.getIssue());
            }
            return this.leftMapToValidationErrors("Could not fetch issue", io.atlassian.fugue.Either.left((Object)issueResult.getErrorCollection()));
        }).then((serviceDesk, mutableIssue) -> this.leftMapToValidationErrors("Could not fetch metric", this.timeMetricService.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, metricId))).yield((serviceDesk, issue, timeMetric) -> {
            DebugConditionResult.ConditionData conditionData;
            TimeMetricDefinitionInfo definitionInfo = this.timeMetricDefinitionService.loadDefinitionConfiguration(user.forJIRA(), (TimeMetric)((Object)timeMetric));
            I18nHelper i18nHelper = user.i18NHelper();
            DebugConditionResult result = new DebugConditionResult();
            result.startConditions = Lists.newArrayList();
            result.pauseConditions = Lists.newArrayList();
            result.stopConditions = Lists.newArrayList();
            for (TimeMetricHitConditionInfo startCondition : definitionInfo.getStartConditions()) {
                conditionData = new DebugConditionResult.ConditionData();
                conditionData.info = ConditionResource.from(i18nHelper, startCondition);
                if (startCondition.isComplete()) {
                    conditionData.history = DebugConditionHistory.from(((TimeMetricHitCondition)startCondition.getCondition()).getHistory((Issue)issue));
                }
                result.startConditions.add(conditionData);
            }
            for (TimeMetricMatchConditionInfo pauseCondition : definitionInfo.getPauseConditions()) {
                conditionData = new DebugConditionResult.ConditionData();
                conditionData.info = ConditionResource.from(i18nHelper, pauseCondition);
                if (pauseCondition.isComplete()) {
                    conditionData.history = DebugConditionHistory.from(((TimeMetricMatchCondition)pauseCondition.getCondition()).getHistory((Issue)issue));
                }
                result.pauseConditions.add(conditionData);
            }
            for (TimeMetricHitConditionInfo stopConditions : definitionInfo.getStopConditions()) {
                conditionData = new DebugConditionResult.ConditionData();
                conditionData.info = ConditionResource.from(i18nHelper, stopConditions);
                if (stopConditions.isComplete()) {
                    conditionData.history = DebugConditionHistory.from(((TimeMetricHitCondition)stopConditions.getCondition()).getHistory((Issue)issue));
                }
                result.stopConditions.add(conditionData);
            }
            return result;
        });
        return this.restResponseHelper.validationErrorsEitherToOkResponse(response);
    }

    private List<DebugCustomField> fromCustomFieldList(List<CustomField> fields) {
        ArrayList result = Lists.newArrayList();
        for (CustomField field : fields) {
            result.add(DebugCustomField.from(field));
        }
        return result;
    }

    private List<DebugGoalData> fromGoalsList(List<Goal> goals) {
        ArrayList datas = Lists.newArrayList();
        for (Goal goal : goals) {
            datas.add(DebugGoalData.from(goal));
        }
        return datas;
    }

    private CustomField findInList(List<CustomField> fields, Long id) {
        for (CustomField field : fields) {
            if (!field.getIdAsLong().equals(id)) continue;
            return field;
        }
        return null;
    }

    private io.atlassian.fugue.Either<ErrorCollection, ServiceDesk> getServiceDeskAndCheckPermission(String projectKey) {
        UncheckedUser uncheckedUser = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either serviceDeskEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(uncheckedUser.forJIRA()))).then(checkedUser -> this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false)).yield((checkedUser, serviceDesk) -> serviceDesk).leftMap(ignoredError -> (ErrorCollection)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.servicedesk.not.found", (Object[])new Object[0]).left().get());
        ServiceDesk serviceDesk2 = (ServiceDesk)serviceDeskEither.right().get();
        boolean isSystemAdmin = this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, uncheckedUser.forJIRA());
        if (!isSystemAdmin && !this.permissionService.canManageSlas(uncheckedUser.forJIRA(), serviceDesk2)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"You require project or system administrator permission.", (Object[])new Object[0]));
        }
        return serviceDeskEither;
    }

    private void setDebugInfo(ApplicationUser user, AbstractDebugResponseData data, ServiceDesk serviceDesk) {
        ProjectService.GetProjectResult project = this.projectService.getProjectById(user, Long.valueOf(serviceDesk.getProjectId()));
        data.generatedAt = new DateTime();
        data.generatedAtString = data.generatedAt.toString();
        data.jiraProjectId = serviceDesk.getProjectId();
        data.jiraProjectKey = project.isValid() ? project.getProject().getKey() : "unknown";
        data.serviceDeskId = serviceDesk.getId();
    }

    private <T> io.atlassian.fugue.Either<ValidationErrors, T> leftMapToValidationErrors(String reasonKey2, io.atlassian.fugue.Either<ErrorCollection, T> either) {
        return either.leftMap(errorCollection -> ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build());
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapErrorCollectionResponse(String reasonKey2, io.atlassian.fugue.Either<ErrorCollection, T> either) {
        return either.leftMap(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build()));
    }
}

