/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.agentview;

import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.rest.sla.GoalResource;
import com.atlassian.servicedesk.internal.rest.sla.SlaConsistencyCheckStatusResponse;
import com.atlassian.servicedesk.internal.rest.sla.TimeMetricDefinitionResource;
import com.atlassian.servicedesk.internal.rest.sla.agentview.CalendarReferenceDataListResponse;
import com.atlassian.servicedesk.internal.rest.sla.agentview.CalendarReferenceResponse;
import com.atlassian.servicedesk.internal.rest.sla.agentview.MetricParamsReponse;
import com.atlassian.servicedesk.internal.rest.sla.agentview.SLAConsistencyDataResponse;
import com.atlassian.servicedesk.internal.rest.sla.agentview.TimeMetricConfigResponse;
import com.atlassian.servicedesk.internal.rest.sla.agentview.TimeMetricEntryResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.GoalResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.TimeMetricDefinitionResponse;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionService;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.CalendarReferenceService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import com.atlassian.servicedesk.internal.sla.goal.GoalStatisticsService;
import com.atlassian.servicedesk.internal.sla.goal.GoalSuccessStatistics;
import com.atlassian.servicedesk.internal.sla.task.SlaConsistencyCheckStatus;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyService;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyState;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSlaHelper {
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final ServiceDeskUserLicenseService serviceDeskUserLicenseService;
    private final ErrorResultHelper errorResultHelper;
    private final SLAFieldService slaFieldService;
    private final InternalTimeMetricService internalTimeMetricService;
    private final GoalStatisticsService goalStatisticsService;
    private final TimeMetricDefinitionService timeMetricDefinitionService;
    private final GoalService goalService;
    private final CalendarReferenceService calendarReferenceService;
    private final SlaDataConsistencyService slaDataConsistencyService;
    private final HelpUrls helpUrls;

    @Autowired
    public ServiceDeskSlaHelper(ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, ServiceDeskUserLicenseService serviceDeskUserLicenseService, ErrorResultHelper errorResultHelper, SLAFieldService slaFieldService, InternalTimeMetricService internalTimeMetricService, GoalStatisticsService goalStatisticsService, TimeMetricDefinitionService timeMetricDefinitionService, GoalService goalService, CalendarReferenceService calendarReferenceService, SlaDataConsistencyService slaDataConsistencyService, HelpUrls helpUrls) {
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.serviceDeskUserLicenseService = serviceDeskUserLicenseService;
        this.errorResultHelper = errorResultHelper;
        this.slaFieldService = slaFieldService;
        this.internalTimeMetricService = internalTimeMetricService;
        this.goalStatisticsService = goalStatisticsService;
        this.timeMetricDefinitionService = timeMetricDefinitionService;
        this.goalService = goalService;
        this.calendarReferenceService = calendarReferenceService;
        this.slaDataConsistencyService = slaDataConsistencyService;
        this.helpUrls = helpUrls;
    }

    public Either<AnError, CalendarReferenceDataListResponse> getCalendarReferences(CheckedUser user, ServiceDesk serviceDesk) {
        if (this.serviceDeskUserLicenseService.hasValidAgentLicense((SDUser)user)) {
            return Either.right((Object)new CalendarReferenceDataListResponse(this.getCalendars(user, serviceDesk)));
        }
        return Either.left((Object)this.createNoPermissionError());
    }

    public Either<AnError, MetricParamsReponse> getMetricParams(CheckedUser user, ServiceDesk serviceDesk, Project project) {
        Either result;
        if (this.serviceDeskLicenseAndPermissionService.canAdministerServiceDesk((SDUser)user, project)) {
            boolean canManageFields = this.slaFieldService.canManageField(user.forJIRA());
            boolean canCreateMetrics = true;
            String helpUrl = this.helpUrls.getUrl("advanced_search").getUrl();
            List<TimeMetricEntryResponse> metrics = this.getTimeMetrics(user, serviceDesk, project);
            List<CalendarReferenceResponse> calendars = this.getCalendars(user, serviceDesk);
            Either<AnError, SLAConsistencyDataResponse> slaConsistencyDataResponseEither = this.getSLAConsistencyData(user, serviceDesk);
            result = slaConsistencyDataResponseEither.map(slaConsistencyData -> new MetricParamsReponse(helpUrl, metrics, calendars, (SLAConsistencyDataResponse)slaConsistencyData, canCreateMetrics, canManageFields));
        } else {
            result = Either.left((Object)this.createNoPermissionError());
        }
        return result;
    }

    public List<TimeMetricEntryResponse> getTimeMetrics(CheckedUser user, ServiceDesk serviceDesk, Project project) {
        List<TimeMetric> metrics = this.internalTimeMetricService.getTimeMetrics(user.forJIRA(), serviceDesk);
        return this.toTimeMetricEntries(user, project, serviceDesk, metrics);
    }

    private List<TimeMetricEntryResponse> toTimeMetricEntries(CheckedUser user, Project project, ServiceDesk serviceDesk, List<TimeMetric> metrics) {
        return metrics.stream().map(entry -> this.toTimeMetricResponse(user, project, serviceDesk, (TimeMetric)((Object)entry))).sorted((f1, f2) -> f1.getName().compareToIgnoreCase(f2.getName())).collect(Collectors.toList());
    }

    public TimeMetricEntryResponse toTimeMetricResponse(CheckedUser user, Project project, ServiceDesk serviceDesk, TimeMetric metric) {
        GoalSuccessStatistics goalStatistics = this.goalStatisticsService.getGoalSuccessStatistics(user.forJIRA(), serviceDesk, metric, GoalStatisticsService.DEFAULT_STATISTICS_PERIOD);
        TimeMetricConfigResponse config = this.getMetricConfig(user, serviceDesk, metric, goalStatistics);
        float successPercentage = this.determinSuccessPercentage(goalStatistics);
        Map<Integer, Float> goalPercentages = this.toGoalPercentagesMap(goalStatistics);
        return new TimeMetricEntryResponse(project.getKey(), metric.getId(), metric.getName(), metric.getCustomFieldId(), successPercentage, config, goalPercentages);
    }

    private TimeMetricConfigResponse getMetricConfig(CheckedUser user, ServiceDesk serviceDesk, TimeMetric timeMetric, GoalSuccessStatistics goalStatistics) {
        TimeMetricDefinitionInfo configuration = this.timeMetricDefinitionService.loadDefinitionConfiguration(user.forJIRA(), timeMetric);
        List<Goal> goals = this.goalService.getAllByTimeMetric(user.forJIRA(), serviceDesk, timeMetric);
        TimeMetricDefinitionResponse definition = TimeMetricDefinitionResource.from(user.i18NHelper(), configuration);
        List<GoalResponse> goalResponses = goals.stream().map(goal -> GoalResource.from(goal)).collect(Collectors.toList());
        return new TimeMetricConfigResponse(definition, goalResponses);
    }

    float determinSuccessPercentage(GoalSuccessStatistics goalSuccessStatistics) {
        return ((Float)goalSuccessStatistics.getOverallPercentage().getOrElse((Object)Float.valueOf(-1.0f))).floatValue();
    }

    Map<Integer, Float> toGoalPercentagesMap(GoalSuccessStatistics statistics) {
        return statistics.getGoalPercentages().entrySet().stream().collect(Collectors.toMap(entry -> ((Goal)((Object)((Object)entry.getKey()))).getId(), Map.Entry::getValue));
    }

    public List<CalendarReferenceResponse> getCalendars(CheckedUser user, ServiceDesk serviceDesk) {
        List<CalendarReference> calendarReferences = this.calendarReferenceService.getAllCalendarReferences(user.forJIRA(), serviceDesk);
        I18nHelper i18NHelper = user.i18NHelper();
        return calendarReferences.stream().map(entry -> new CalendarReferenceResponse(entry.getId(), entry.isDefaultCalendar(), entry.getName(i18NHelper))).collect(Collectors.toList());
    }

    Either<AnError, SLAConsistencyDataResponse> getSLAConsistencyData(CheckedUser user, ServiceDesk serviceDesk) {
        if (this.serviceDeskUserLicenseService.hasValidAgentLicense((SDUser)user)) {
            SlaDataConsistencyState consistencyState = this.slaDataConsistencyService.getSLADataConsistencyState(user.forJIRA(), serviceDesk);
            SlaConsistencyCheckStatus info = consistencyState.getStatus();
            SLAConsistencyDataResponse data = new SLAConsistencyDataResponse(consistencyState.getTotalIssueCount(), consistencyState.getOutdatedIssueCount(), consistencyState.isUpToDate(), info.isKickedOff(), SlaConsistencyCheckStatusResponse.toResponse(info));
            return Either.right((Object)data);
        }
        return Either.left((Object)this.createNoPermissionError());
    }

    private AnError createNoPermissionError() {
        return this.errorResultHelper.forbidden403("sd.sla.nav.no.permission", new Object[0]).build();
    }
}

