/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla.admin;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.featureflag.ServiceDeskFeatureFlags;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.rest.sla.admin.response.AdminSlaReconstructionResult;
import com.atlassian.servicedesk.internal.rest.sla.debug.response.DebugSLAValue;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAValueSerializer;
import com.atlassian.servicedesk.internal.sla.customfield.SlaFieldUpdateLockManager;
import com.atlassian.servicedesk.internal.sla.goal.GoalMatcher;
import com.atlassian.servicedesk.internal.sla.goal.IssueIndexingContext;
import com.atlassian.servicedesk.internal.sla.metric.CycleMetricData;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractor;
import com.atlassian.servicedesk.internal.sla.metric.TimeMetricCalculationService;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.ThresholdData;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdEventManager;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdUpdateContext;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseSlaScheduleOrigin;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/servicedesk/sla/admin/task/destructive/reconstruct")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SlaReconstructionResource {
    private static final EntityPropertyOptions SKIP_PERMISSION_OPTIONS = new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    private static final String ISSUE_PROPERTY_USER_KEY_SUFFIX = "sla.admin.reconstruct.resource.userkey";
    private static final String ISSUE_PROPERTY_CUSTOMFIELDID_SUFFIX = "sla.admin.reconstruct.resource.customfieldid";
    private static final String ISSUE_PROPERTY_BEFORE_SUFFIX = "sla.admin.reconstruct.resource.before";
    private static final String ISSUE_PROPERTY_AFTER_SUFFIX = "sla.admin.reconstruct.resource.after";
    private static final String ISSUE_PROPERTY_NO_CHANGE_SUFFIX = "sla.admin.reconstruct.resource.nochange";
    private static final SLAValueSerializer SLA_VALUE_SERIALIZER = new SLAValueSerializer();
    private final UserFactory userFactory;
    private final IssueManager issueManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final GlobalPermissionManager globalPermissionManager;
    private final InternalServiceDeskService serviceDeskService;
    private final TimeMetricCalculationService timeMetricCalculationService;
    private final MetricStateHistoryExtractor metricStateHistoryExtractor;
    private final InternalTimeMetricService timeMetricService;
    private final MetricConditionRefManager metricConditionRefManager;
    private final GoalMatcher goalMatcher;
    private final CalendarReferenceManager calendarReferenceManager;
    private final SLAFieldManager slaFieldManager;
    private final IssueIndexingService issueIndexingService;
    private final SlaThresholdEventManager slaThresholdEventManager;
    private final IssuePropertyService issuePropertyService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;
    private final SlaFieldUpdateLockManager slaFieldUpdateLockManager;
    private final FeatureManager featureManager;

    private static String ISSUE_PROPERTY_KEY(long currentTime, int counter, @Nonnull String key) {
        return currentTime + "-" + counter + "-" + key;
    }

    private static String ISSUE_PROPERTY_BEFORE(long currentTime, int counter) {
        return SlaReconstructionResource.ISSUE_PROPERTY_KEY(currentTime, counter, ISSUE_PROPERTY_BEFORE_SUFFIX);
    }

    private static String ISSUE_PROPERTY_AFTER(long currentTime, int counter) {
        return SlaReconstructionResource.ISSUE_PROPERTY_KEY(currentTime, counter, ISSUE_PROPERTY_AFTER_SUFFIX);
    }

    private static String ISSUE_PROPERTY_CUSTOMFIELDID(long currentTime, int counter) {
        return SlaReconstructionResource.ISSUE_PROPERTY_KEY(currentTime, counter, ISSUE_PROPERTY_CUSTOMFIELDID_SUFFIX);
    }

    private static String ISSUE_PROPERTY_USER_KEY(long currentTime, int counter) {
        return SlaReconstructionResource.ISSUE_PROPERTY_KEY(currentTime, counter, ISSUE_PROPERTY_USER_KEY_SUFFIX);
    }

    private static String ISSUE_PROPERTY_NO_CHANGE(long currentTime, int counter) {
        return SlaReconstructionResource.ISSUE_PROPERTY_KEY(currentTime, counter, ISSUE_PROPERTY_NO_CHANGE_SUFFIX);
    }

    private static SLAValue sanitizeSlaValueForComparison(SLAValue value) {
        SLAValue.Builder newBuilder = SLAValue.builder(value);
        if (newBuilder.getOngoingSLAData() != null) {
            OngoingSLAData.Builder ongoingSLADataBuilder = newBuilder.getOngoingSLADataBuilder();
            Option thresholdData = ongoingSLADataBuilder.getThresholdData().map(threshold -> ThresholdData.builder(threshold).calculatedAt(null).remainingTime((Option<Long>)Option.none()).build());
            ongoingSLADataBuilder.thresholdData((Option<ThresholdData>)thresholdData);
            newBuilder.ongoingSLAData(ongoingSLADataBuilder.build());
        }
        if (newBuilder.getMetricCreatedDate() == null) {
            newBuilder.setMetricCreatedDate(0L);
        }
        return newBuilder.build();
    }

    protected SlaReconstructionResource(UserFactory userFactory, IssueManager issueManager, I18nHelper.BeanFactory i18nFactory, ServiceDeskPermissions serviceDeskPermissions, GlobalPermissionManager globalPermissionManager, InternalServiceDeskService serviceDeskService, TimeMetricCalculationService timeMetricCalculationService, MetricStateHistoryExtractor metricStateHistoryExtractor, InternalTimeMetricService timeMetricService, MetricConditionRefManager metricConditionRefManager, GoalMatcher goalMatcher, CalendarReferenceManager calendarReferenceManager, SLAFieldManager slaFieldManager, IssueIndexingService issueIndexingService, SlaThresholdEventManager slaThresholdEventManager, IssuePropertyService issuePropertyService, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper, SlaFieldUpdateLockManager slaFieldUpdateLockManager, FeatureManager featureManager) {
        this.userFactory = userFactory;
        this.issueManager = issueManager;
        this.i18nFactory = i18nFactory;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.globalPermissionManager = globalPermissionManager;
        this.serviceDeskService = serviceDeskService;
        this.timeMetricCalculationService = timeMetricCalculationService;
        this.metricStateHistoryExtractor = metricStateHistoryExtractor;
        this.timeMetricService = timeMetricService;
        this.metricConditionRefManager = metricConditionRefManager;
        this.goalMatcher = goalMatcher;
        this.calendarReferenceManager = calendarReferenceManager;
        this.slaFieldManager = slaFieldManager;
        this.issueIndexingService = issueIndexingService;
        this.slaThresholdEventManager = slaThresholdEventManager;
        this.issuePropertyService = issuePropertyService;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
        this.slaFieldUpdateLockManager = slaFieldUpdateLockManager;
        this.featureManager = featureManager;
    }

    @POST
    public Response recreateBrokenIssues(@QueryParam(value="force") String forceString, List<String> issueKeys) {
        boolean force = Boolean.valueOf(forceString);
        io.atlassian.fugue.Either checkedUserEither = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        io.atlassian.fugue.Either jiraAdminUserEither = checkedUserEither.flatMap(checkedUser -> {
            boolean isSystemAdmin = this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, checkedUser.forJIRA());
            io.atlassian.fugue.Either flatMappedEither = isSystemAdmin || this.serviceDeskPermissions.canAdministerJIRA((SDUser)checkedUser) ? io.atlassian.fugue.Either.right((Object)checkedUser) : StepsConverters.newerEither((Either)this.errorResultHelper.error(checkedUser.forJIRA(), HttpStatusCode.FORBIDDEN, "sd.admin.servicedesk.common.error.permissions", new Object[0]));
            return flatMappedEither;
        }).leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0));
        if (jiraAdminUserEither.isLeft()) {
            return (Response)jiraAdminUserEither.left().get();
        }
        CheckedUser checkedUser2 = (CheckedUser)jiraAdminUserEither.right().get();
        if (issueKeys == null || Iterables.any(issueKeys, Objects::isNull)) {
            return this.restResponseHelper.badRequest("No issue keys provided or a null value included");
        }
        IssueSearcher.log.warn((Object)("Requested to destructively recreate all SLA metrics for issues : " + issueKeys));
        HashMap results = Maps.newHashMap();
        for (String issueKey : Sets.newLinkedHashSet(issueKeys)) {
            results.put(issueKey, this.recreateSlaForIssue(checkedUser2, issueKey, force));
        }
        IssueSearcher.log.warn((Object)("Recreated SLA metrics for " + results.values().stream().filter(io.atlassian.fugue.Either::isRight).count() + " issues"));
        IssueSearcher.log.warn((Object)("Problems prevents SLA metrics for " + results.values().stream().filter(io.atlassian.fugue.Either::isLeft).count() + " issues being recreated"));
        return this.restResponseHelper.ok((Object)SLA_VALUE_SERIALIZER.serialize(AdminSlaReconstructionResult.from(results)));
    }

    private io.atlassian.fugue.Either<ErrorCollection, Collection<DebugSLAValue>> recreateSlaForIssue(@Nonnull CheckedUser user, @Nonnull String issueKey, boolean force) {
        try {
            MutableIssue issue = this.issueManager.getIssueObject(issueKey);
            if (issue == null) {
                IssueSearcher.log.warn((Object)("Issue can not have SLA metrics updates, as it not a valid issue : " + issueKey));
                return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"Issue does not exist", (Object[])new Object[0]));
            }
            Project project = issue.getProjectObject();
            if (project == null) {
                IssueSearcher.log.warn((Object)("Issue can not have SLA metrics updates, as it does not have a valid project : " + issueKey));
                return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"Issue does not have a valid project", (Object[])new Object[0]));
            }
            io.atlassian.fugue.Either serviceDeskEither = this.serviceDeskService.getServiceDeskForProject(user, project, false);
            if (serviceDeskEither.isLeft()) {
                IssueSearcher.log.warn((Object)("Issue can not have SLA metrics updates, as it is not from a valid Service Desk : " + issueKey));
                return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.servicedesk.not.found", (Object[])new Object[0]));
            }
            ServiceDesk serviceDesk = (ServiceDesk)serviceDeskEither.right().get();
            Collection<Pair<SLAValue, TimeMetric>> slaValues = this.recreateSLAValueAndDestructivelyUpdate(user.forJIRA(), serviceDesk, (Issue)issue, force);
            IssueSearcher.log.warn((Object)("Successfully recreated SLA metrics for issue : " + issueKey));
            return io.atlassian.fugue.Either.right((Object)Collections2.transform(slaValues, pair -> DebugSLAValue.from((SLAValue)pair.left(), ((TimeMetric)((Object)((Object)pair.right()))).getCustomFieldId(), ((TimeMetric)((Object)((Object)pair.right()))).getName())));
        }
        catch (Exception e) {
            IssueSearcher.log.error((Object)("Unexpected error while updating the SLA value for issue " + issueKey), (Throwable)e);
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR, (String)("Unexpected error while updating the SLA Value - " + e.getMessage()), (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Pair<SLAValue, TimeMetric>> recreateSLAValueAndDestructivelyUpdate(@Nonnull ApplicationUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull Issue issue, boolean force) throws IndexException {
        ArrayList values2 = Lists.newArrayList();
        SlaThresholdUpdateContext slaThresholdUpdateContext = new SlaThresholdUpdateContext(issue);
        List<TimeMetric> timeMetrics = this.timeMetricService.getTimeMetrics(user, serviceDesk);
        DateTime now = DateTime.now();
        long timestamp = now.getMillis();
        int counter = 1;
        boolean anySlaValueChanged = false;
        for (TimeMetric timeMetric : timeMetrics) {
            this.slaFieldUpdateLockManager.lockSlaUpdate(issue, timeMetric);
            try {
                List<MetricConditionRef> conditions = this.metricConditionRefManager.getMetricConditions(timeMetric);
                com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = this.goalMatcher.getMatchingGoal(issue, timeMetric, IssueIndexingContext.indexingRequired());
                SLAValue calculatedSLAValueWithOngoing = this.metricStateHistoryExtractor.calculateSLAValueForSpecialDebugAndAdminPurposes(issue, timeMetric, conditions, goal, now);
                SLAValue.Builder builder = SLAValue.builder(calculatedSLAValueWithOngoing);
                builder.completeSLAData(this.getCompletedSlaData(goal, user, builder.getTimeline(), now));
                SLAValue newValue = builder.build();
                String newSerializedValue = SLA_VALUE_SERIALIZER.serialize(newValue);
                SLAValue currentValue = this.slaFieldManager.getFieldValue(issue, timeMetric);
                String currentSerializedSlaValue = SLA_VALUE_SERIALIZER.serialize(currentValue);
                String newSerializedValueToCompare = SLA_VALUE_SERIALIZER.serialize(SlaReconstructionResource.sanitizeSlaValueForComparison(newValue));
                String currentSerializedSlaValueToCompare = SLA_VALUE_SERIALIZER.serialize(SlaReconstructionResource.sanitizeSlaValueForComparison(currentValue));
                this.saveIssueProperty(user, issue, JSONObject.quote((String)user.getKey()), SlaReconstructionResource.ISSUE_PROPERTY_USER_KEY(timestamp, counter));
                this.saveIssueProperty(user, issue, JSONObject.quote((String)String.valueOf(timeMetric.getCustomFieldId())), SlaReconstructionResource.ISSUE_PROPERTY_CUSTOMFIELDID(timestamp, counter));
                if (force || !Objects.equals(newSerializedValueToCompare, currentSerializedSlaValueToCompare)) {
                    anySlaValueChanged = true;
                    this.saveIssueProperty(user, issue, currentSerializedSlaValue, SlaReconstructionResource.ISSUE_PROPERTY_BEFORE(timestamp, counter));
                    this.saveIssueProperty(user, issue, newSerializedValue, SlaReconstructionResource.ISSUE_PROPERTY_AFTER(timestamp, counter));
                    this.slaFieldManager.setFieldValue(timeMetric, issue, newValue);
                    this.slaThresholdEventManager.calculateNextExceedingSlaThresholdTime(timeMetric, newValue, now, slaThresholdUpdateContext);
                } else {
                    this.saveIssueProperty(user, issue, currentSerializedSlaValue, SlaReconstructionResource.ISSUE_PROPERTY_NO_CHANGE(timestamp, counter));
                }
                values2.add(Pair.pair((Object)newValue, (Object)((Object)timeMetric)));
                ++counter;
            }
            finally {
                this.slaFieldUpdateLockManager.unlockSlaUpdate(issue, timeMetric);
            }
        }
        if (anySlaValueChanged) {
            this.issueIndexingService.reIndex(issue);
            this.slaThresholdEventManager.scheduleNextExceedingSlaThresholdTimedPromise(slaThresholdUpdateContext, TimedPromiseSlaScheduleOrigin.ADMIN_RECONSTRUCTION_RESOURCE);
        }
        return values2;
    }

    private List<CompleteSLAData> getCompletedSlaData(com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, ApplicationUser user, Timeline timeline, DateTime now) {
        if (goal.getDuration() == null) {
            return Collections.emptyList();
        }
        CalendarReference referenceForGoal = this.calendarReferenceManager.getReferenceForGoal((Goal)goal);
        WorkingHoursCalculator calculatorForReference = this.calendarReferenceManager.getCalculatorForReference(referenceForGoal);
        if (this.featureManager.isEnabled(ServiceDeskFeatureFlags.SLA_IMPROVED_RENDERING)) {
            return this.timeMetricCalculationService.getAllCycleMetricData(timeline, calculatorForReference, now).stream().filter(cycle -> !cycle.isOngoing()).map(cycleMetricData -> this.timeMetricCalculationService.getRemainingTimeInDaysAndMillisForCompletedGoal(timeline, calculatorForReference, goal.getDuration() - cycleMetricData.getDuration(), (CycleMetricData)cycleMetricData)).map(cycleMetricData -> this.buildCompletedSLAData(referenceForGoal, user, (CycleMetricData)cycleMetricData, goal)).collect(Collectors.toList());
        }
        return this.timeMetricCalculationService.getAllCycleMetricData(timeline, calculatorForReference, now).stream().filter(cycle -> !cycle.isOngoing()).map(cycleMetricData -> this.buildCompletedSLAData(referenceForGoal, user, (CycleMetricData)cycleMetricData, goal)).collect(Collectors.toList());
    }

    private CompleteSLAData buildCompletedSLAData(CalendarReference referenceForGoal, ApplicationUser user, CycleMetricData cycleMetricData, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        Long remaining = goal.getDuration() - cycleMetricData.getDuration();
        return CompleteSLAData.builder().calendarName(referenceForGoal.getName(i18nHelper)).elapsedTime(cycleMetricData.getDuration()).remainingTime(remaining).remainingTimeInDaysAndMillis(cycleMetricData.getRemainingTimeInDaysAndMillis()).startTime(cycleMetricData.getRange().getStart()).stopTime(cycleMetricData.getRange().getStop()).goalTime(goal.getDuration()).succeeded(cycleMetricData.getDuration() <= goal.getDuration()).build();
    }

    private void saveIssueProperty(@Nonnull ApplicationUser user, @Nonnull Issue issue, @Nonnull String issuePropertyValue, @Nonnull String issuePropertyKey) {
        EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(issuePropertyValue, issuePropertyKey);
        EntityPropertyService.SetPropertyValidationResult setPropertyValidationResult = this.issuePropertyService.validateSetProperty(user, issue.getId(), propertyInput, SKIP_PERMISSION_OPTIONS);
        this.issuePropertyService.setProperty(user, setPropertyValidationResult);
    }
}

