/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.SlaConsistencyCheckStatusResponse;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/servicedesk/{projectKey}/sla/consistency")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SlaConsistencyResource {
    private static final Logger LOG = LoggerFactory.getLogger(SlaConsistencyResource.class);
    private final SlaDataConsistencyService slaDataConsistencyService;
    private final UserFactory userFactory;
    private final InternalServiceDeskService serviceDeskService;
    private final RestResponseHelper restResponseHelper;

    public SlaConsistencyResource(InternalServiceDeskService serviceDeskService, SlaDataConsistencyService slaDataConsistencyService, UserFactory userFactory, RestResponseHelper restResponseHelper) {
        this.slaDataConsistencyService = slaDataConsistencyService;
        this.serviceDeskService = serviceDeskService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response getSlaConsistencyCheckStatus(@PathParam(value="projectKey") String projectKey) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.getServiceDesk(projectKey).map(serviceDesk -> this.slaDataConsistencyService.getConsistencyCheckStatus(this.userFactory.getUncheckedUser().forJIRA(), (ServiceDesk)serviceDesk)).map(SlaConsistencyCheckStatusResponse::toResponse));
    }

    @POST
    public Response requestSlaConsistencyCheck(@PathParam(value="projectKey") String projectKey, @QueryParam(value="reason") String reason) {
        return (Response)Eithers.merge((io.atlassian.fugue.Either)Steps.begin(this.leftMapAnErrorResponse(this.getServiceDesk(projectKey))).then(serviceDesk -> this.leftMapErrorCollectionResponse("Cannot start consistency check", this.slaDataConsistencyService.requestConsistencyCheck(this.userFactory.getUncheckedUser().forJIRA(), (ServiceDesk)serviceDesk, this.determineReason(reason)))).yield((serviceDesk, queueProgressInfo) -> this.restResponseHelper.ok((Object)SlaConsistencyCheckStatusResponse.toResponse(queueProgressInfo))));
    }

    @DELETE
    public Response cancelSlaConsistencyCheck(@PathParam(value="projectKey") String projectKey) {
        return (Response)Eithers.merge((io.atlassian.fugue.Either)Steps.begin(this.leftMapAnErrorResponse(this.getServiceDesk(projectKey))).then(serviceDesk -> this.leftMapErrorCollectionResponse("Cannot stop consistency check", this.slaDataConsistencyService.cancelConsistencyCheck(this.userFactory.getUncheckedUser().forJIRA(), (ServiceDesk)serviceDesk))).yield((serviceDesk, unit) -> this.restResponseHelper.noContent()));
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> getServiceDesk(String projectKey) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false)).yield((checkedUser, serviceDesk) -> serviceDesk);
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapAnErrorResponse(io.atlassian.fugue.Either<AnError, T> either) {
        return either.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0));
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapErrorCollectionResponse(String reasonKey2, io.atlassian.fugue.Either<ErrorCollection, T> either) {
        return either.leftMap(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build()));
    }

    @VisibleForTesting
    Option<SlaAuditLogReason> determineReason(String reason) {
        try {
            return Option.option((Object)reason).map(SlaAuditLogReason::valueOf);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Given reason is not in the list of valid ones: " + reason);
            return Option.none();
        }
    }
}

