/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.response.auditlog.SlaAuditLogIssueResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.auditlog.SlaAuditLogResponse;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogChangeRenderer;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogEntry;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.BooleanUtils;

@Path(value="/servicedesk/{projectKey}/sla/auditlog/{timeMetricId}")
@Produces(value={"application/json"})
public class SlaAuditLogResource {
    private final RestResponseHelper restResponseHelper;
    private final SlaAuditLogService slaAuditLogService;
    private final SlaAuditLogChangeRenderer slaAuditLogChangeRenderer;
    private final TimeZoneManager timeZoneManager;
    private final LocaleManager localeManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public SlaAuditLogResource(RestResponseHelper restResponseHelper, SlaAuditLogService slaAuditLogService, SlaAuditLogChangeRenderer slaAuditLogChangeRenderer, TimeZoneManager timeZoneManager, LocaleManager localeManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.restResponseHelper = restResponseHelper;
        this.slaAuditLogService = slaAuditLogService;
        this.slaAuditLogChangeRenderer = slaAuditLogChangeRenderer;
        this.timeZoneManager = timeZoneManager;
        this.localeManager = localeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @Path(value="/issues")
    public Response getIssues(@PathParam(value="projectKey") String projectKey, @PathParam(value="timeMetricId") Long timeMetricId, @QueryParam(value="q") String issueKeySearchPattern) {
        Either responses = this.slaAuditLogService.retrieveIssueListOfTimeMetric(projectKey, timeMetricId, issueKeySearchPattern).map(this::convertToResponses);
        return this.restResponseHelper.anErrorEitherToOkResponse(responses);
    }

    @GET
    public Response getLogs(@PathParam(value="projectKey") String projectKey, @PathParam(value="timeMetricId") Long timeMetricId, @QueryParam(value="issueId") Long issueId, @QueryParam(value="showGlobal") Boolean showGlobal) {
        Either responses = this.slaAuditLogService.retrieveAuditEntries(projectKey, timeMetricId, (Option<Long>)Option.option((Object)issueId), BooleanUtils.isTrue((Boolean)showGlobal)).map(this::convertToResponses);
        return this.restResponseHelper.anErrorEitherToOkResponse(responses);
    }

    private List<SlaAuditLogIssueResponse> convertToResponses(Map<Long, String> issues) {
        return issues.entrySet().stream().map(entry -> new SlaAuditLogIssueResponse((Long)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    private List<SlaAuditLogResponse> convertToResponses(List<SlaAuditLogEntry> entries) {
        DateTimeFormatter formatter = this.getDateFormat();
        return entries.stream().map(entry -> this.createResponse((SlaAuditLogEntry)entry, formatter)).collect(Collectors.toList());
    }

    private SlaAuditLogResponse createResponse(SlaAuditLogEntry entry, DateTimeFormatter formatter) {
        String change = this.slaAuditLogChangeRenderer.render(entry, formatter);
        return new SlaAuditLogResponse((Long)entry.getIssueId().getOrNull(), (Long)entry.getTimeMetricId().getOrNull(), this.formatEventTime(entry.getEventTime(), formatter), (String)this.slaAuditLogChangeRenderer.getIssueKey(entry).getOrNull(), change);
    }

    private String formatEventTime(long eventTime, DateTimeFormatter formatter) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(eventTime), formatter.getZone()).format(formatter);
    }

    private DateTimeFormatter getDateFormat() {
        TimeZone timeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        Locale locale = this.localeManager.getLocaleFor(this.jiraAuthenticationContext.getLoggedInUser());
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.MEDIUM).withZone(timeZone.toZoneId()).withLocale(locale);
    }
}

