/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.response.SLAIssueResponse;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalDetailedViewData;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalViewService;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/sla/issue/{issueKey}")
@Produces(value={"application/json"})
public class SLAIssueResource {
    private final GoalViewService goalViewService;
    private final IssueService issueService;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final ErrorResultHelper errorResultHelper;

    public SLAIssueResource(GoalViewService goalViewService, IssueService issueService, RestResponseHelper restResponseHelper, UserFactory userFactory, ErrorResultHelper errorResultHelper) {
        this.goalViewService = goalViewService;
        this.issueService = issueService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.errorResultHelper = errorResultHelper;
    }

    @GET
    public Response getIssueSLA(@PathParam(value="issueKey") String issueKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user.forJIRA(), issueKey);
        if (issueResult == null) {
            return this.restResponseHelper.anErrorToResponse(this.errorResultHelper.notFound404("sd.sla.issue.error.result.null", new Object[0]).build());
        }
        if (!issueResult.isValid()) {
            return this.restResponseHelper.anErrorToResponse(this.errorResultHelper.forbidden403("sd.sla.issue.error.result.not.valid", new Object[0]).build());
        }
        List<GoalDetailedViewData> goalDataForDetailView = this.goalViewService.getGoalDataForDetailView(user.forJIRA(), (Issue)issueResult.getIssue());
        boolean hasPreviousCycles = false;
        for (GoalDetailedViewData data : goalDataForDetailView) {
            if (data.getCompleteGoals() == null || data.getCompleteGoals().isEmpty()) continue;
            hasPreviousCycles = true;
        }
        return this.restResponseHelper.ok((Object)new SLAIssueResponse(hasPreviousCycles, goalDataForDetailView));
    }
}

