/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.rest.sla.response.CompleteCycleResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.FieldMetricResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.FieldSlaResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.MetricDurationResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.MetricValueResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.OngoingCycleResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.SlaValueResponse;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.goal.GoalMatcher;
import com.atlassian.servicedesk.internal.sla.goal.IssueIndexingContext;
import com.atlassian.servicedesk.internal.sla.goal.OngoingGoalStatus;
import com.atlassian.servicedesk.internal.sla.metric.CycleMetricData;
import com.atlassian.servicedesk.internal.sla.metric.TimeMetricCalculationService;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/sla/field/all/data/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SLAFieldValueResource {
    private final IssueService issueService;
    private final TimeMetricCalculationService timeMetricCalculationService;
    private final GoalCalculationService goalCalculationService;
    private final InternalTimeMetricService timeMetricService;
    private final ServiceDeskService serviceDeskService;
    private final SLAFieldService slaFieldService;
    private final CalendarReferenceManager calendarReferenceManager;
    private final GoalService goalService;
    private final GoalMatcher goalMatcher;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;

    public SLAFieldValueResource(IssueService issueService, TimeMetricCalculationService timeMetricCalculationService, GoalCalculationService goalCalculationService, InternalTimeMetricService timeMetricService, ServiceDeskService serviceDeskService, SLAFieldService slaFieldService, CalendarReferenceManager calendarReferenceManager, GoalService goalService, GoalMatcher goalMatcher, RestResponseHelper restResponseHelper, UserFactory userFactory) {
        this.issueService = issueService;
        this.timeMetricCalculationService = timeMetricCalculationService;
        this.goalCalculationService = goalCalculationService;
        this.timeMetricService = timeMetricService;
        this.serviceDeskService = serviceDeskService;
        this.slaFieldService = slaFieldService;
        this.calendarReferenceManager = calendarReferenceManager;
        this.goalService = goalService;
        this.goalMatcher = goalMatcher;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
    }

    @GET
    @Path(value="/metric")
    public Response getFieldMetric(@QueryParam(value="issueId") Long issueId, @QueryParam(value="issueKey") String issueKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapErrorCollectionResponse("Cannot access issue", this.getIssue(issueId, issueKey))).then(issue -> this.leftMapAnErrorResponse(StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), issue.getProjectObject())))).yield((issue, serviceDesk) -> this.yieldFieldMetricResponse((SDUser)user, (Issue)issue, (ServiceDesk)serviceDesk));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.map(arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0)));
    }

    private FieldMetricResponse yieldFieldMetricResponse(SDUser user, Issue issue, ServiceDesk serviceDesk) {
        FieldMetricResponse response = new FieldMetricResponse();
        DateTime now = new DateTime();
        for (TimeMetric timeMetric : this.timeMetricService.getTimeMetrics(user.forJIRA(), serviceDesk)) {
            io.atlassian.fugue.Either<ErrorCollection, CustomField> customFieldResult = this.slaFieldService.getById(user.forJIRA(), timeMetric.getCustomFieldId());
            if (customFieldResult.isLeft()) continue;
            com.atlassian.servicedesk.internal.sla.configuration.goal.Goal matchingGoal = this.goalMatcher.getMatchingGoal(issue, timeMetric, IssueIndexingContext.noIndexing());
            WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForGoal((Goal)matchingGoal);
            CustomField cf = (CustomField)customFieldResult.right().get();
            MetricValueResponse metricValue = this.getMetricValue(issue, cf, calculator, now);
            response.metricValues.add(metricValue);
        }
        return response;
    }

    private MetricValueResponse getMetricValue(Issue issue, CustomField cf, WorkingHoursCalculator calculator, DateTime now) {
        MetricValueResponse metricValue = new MetricValueResponse();
        metricValue.customFieldId = cf.getIdAsLong();
        metricValue.customFieldName = cf.getFieldName();
        SLAValue value = this.slaFieldService.getFieldValue(this.userFactory.getUncheckedUser().forJIRA(), issue, cf);
        List<CycleMetricData> cycleDurations = this.timeMetricCalculationService.getAllCycleMetricData(value.getTimeline(), calculator, now);
        for (CycleMetricData duration : cycleDurations) {
            MetricDurationResponse durationResponse = new MetricDurationResponse();
            durationResponse.elapsedTime = duration.getDuration();
            durationResponse.isOngoing = duration.isOngoing();
            metricValue.durations.add(durationResponse);
        }
        return metricValue;
    }

    @GET
    @Path(value="/sla")
    public Response getFieldSla(@QueryParam(value="issueId") Long issueId, @QueryParam(value="issueKey") String issueKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        io.atlassian.fugue.Either result = Steps.begin(this.leftMapErrorCollectionResponse("Cannot access issue", this.getIssue(issueId, issueKey))).then(issue -> this.leftMapAnErrorResponse(StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), issue.getProjectObject())))).yield((issue, serviceDesk) -> this.yieldFieldSlaResponse((SDUser)user, (Issue)issue, (ServiceDesk)serviceDesk));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.map(arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0)));
    }

    private FieldSlaResponse yieldFieldSlaResponse(SDUser user, Issue issue, ServiceDesk serviceDesk) {
        FieldSlaResponse response = new FieldSlaResponse();
        DateTime now = new DateTime();
        for (TimeMetric timeMetric : this.timeMetricService.getTimeMetrics(user.forJIRA(), serviceDesk)) {
            Option<SlaValueResponse> slaResponse;
            io.atlassian.fugue.Either<ErrorCollection, CustomField> customFieldResult = this.slaFieldService.getById(user.forJIRA(), timeMetric.getCustomFieldId());
            if (customFieldResult.isLeft() || !(slaResponse = this.getSlaValue(issue, timeMetric, (CustomField)customFieldResult.right().get(), now)).isDefined()) continue;
            response.metricValues.add((SlaValueResponse)slaResponse.get());
        }
        return response;
    }

    private Option<SlaValueResponse> getSlaValue(Issue issue, TimeMetric timeMetric, CustomField cf, DateTime now) {
        SlaValueResponse slaResponse = new SlaValueResponse();
        slaResponse.customFieldId = cf.getIdAsLong();
        slaResponse.customFieldName = cf.getFieldName();
        SLAValue value = this.slaFieldService.getFieldValue(this.userFactory.getUncheckedUser().forJIRA(), issue, cf);
        Option<OngoingCycleResponse> ongoingGoalResponse = this.getOngoingGoalResponse(value, timeMetric, now);
        if (ongoingGoalResponse.isDefined()) {
            slaResponse.ongoingCycle = (OngoingCycleResponse)ongoingGoalResponse.get();
        }
        for (CompleteSLAData complete : value.getCompleteSLAData()) {
            slaResponse.completeCycles.add(this.toResponse(complete));
        }
        return Option.some((Object)slaResponse);
    }

    private Option<OngoingCycleResponse> getOngoingGoalResponse(SLAValue value, TimeMetric timeMetric, DateTime now) {
        OngoingSLAData ongoingSLAData = value.getOngoingSLAData();
        if (ongoingSLAData == null) {
            return Option.none();
        }
        io.atlassian.fugue.Either<ErrorCollection, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal> goal = this.goalService.getGoal(this.userFactory.getUncheckedUser().forJIRA(), timeMetric, ongoingSLAData.getGoalId());
        if (goal.isLeft()) {
            IssueSearcher.log.warn((Object)("Error getting sla goal:" + goal.left().get()));
            return Option.none();
        }
        Option<OngoingGoalStatus> ongoingGoalStatus = this.goalCalculationService.getOngoingGoalStatus((com.atlassian.servicedesk.internal.sla.configuration.goal.Goal)((Object)goal.right().get()), value, now);
        if (ongoingGoalStatus.isEmpty()) {
            return Option.none();
        }
        return Option.some((Object)this.toResponse((OngoingGoalStatus)ongoingGoalStatus.get()));
    }

    private OngoingCycleResponse toResponse(OngoingGoalStatus status) {
        OngoingCycleResponse response = new OngoingCycleResponse();
        response.goalId = status.getGoalId();
        response.startDate = status.getStartDate();
        response.elapsedTime = status.getElapsedTime();
        response.breached = status.hasFailed();
        response.paused = status.isPaused();
        response.breachedDate = status.getBreachedDate();
        response.isPaused = status.isPaused();
        response.startTime = status.getStartDate();
        response.hasFailed = status.hasFailed();
        return response;
    }

    private CompleteCycleResponse toResponse(CompleteSLAData complete) {
        CompleteCycleResponse response = new CompleteCycleResponse();
        response.calendarName = complete.getCalendarName();
        response.elapsedTime = complete.getElapsedTime();
        response.goalTime = complete.getGoalTime();
        response.startDate = complete.getStartTime();
        response.stopDate = complete.getStopTime();
        response.breached = !complete.isSucceeded();
        response.startTime = complete.getStartTime();
        response.stopTime = complete.getStopTime();
        response.succeeded = complete.isSucceeded();
        return response;
    }

    private io.atlassian.fugue.Either<ErrorCollection, Issue> getIssue(Long issueId, String issueKey) {
        IssueService.IssueResult issue;
        UncheckedUser user = this.userFactory.getUncheckedUser();
        if (issueId != null) {
            issue = this.issueService.getIssue(user.forJIRA(), issueId);
        } else if (issueKey != null) {
            issue = this.issueService.getIssue(user.forJIRA(), issueKey);
        } else {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)user.i18NHelper().getText("sd.sla.field.value.service.missing-issue"), (Object[])new Object[0]));
        }
        if (!issue.isValid()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection)issue.getErrorCollection()));
        }
        return io.atlassian.fugue.Either.right((Object)issue.getIssue());
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapAnErrorResponse(io.atlassian.fugue.Either<AnError, T> either) {
        return either.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0));
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapErrorCollectionResponse(String reasonKey2, io.atlassian.fugue.Either<ErrorCollection, T> either) {
        return either.leftMap(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build()));
    }
}

