/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.request.GoalRequest;
import com.atlassian.servicedesk.internal.rest.sla.request.GoalsRequest;
import com.atlassian.servicedesk.internal.rest.sla.response.GoalResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.GoalsResponse;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.CalendarReferenceService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalWithTimeMetricId;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import io.atlassian.fugue.Eithers;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/sla")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GoalResource {
    private final GoalService goalService;
    private final InternalTimeMetricService timeMetricService;
    private final InternalServiceDeskService serviceDeskService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final CalendarReferenceService calendarReferenceService;

    public GoalResource(GoalService goalService, InternalServiceDeskService serviceDeskService, InternalTimeMetricService timeMetricService, UserFactory userFactory, RestResponseHelper restResponseHelper, I18nHelper.BeanFactory i18nBeanFactory, CalendarReferenceService calendarReferenceService) {
        this.goalService = goalService;
        this.timeMetricService = timeMetricService;
        this.serviceDeskService = serviceDeskService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
        this.i18nBeanFactory = i18nBeanFactory;
        this.calendarReferenceService = calendarReferenceService;
    }

    @GET
    @Path(value="goals/metric/{metricId}")
    public Response getAllByMetric(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") Long metricId) {
        if (metricId == null) {
            return this.restResponseHelper.badRequest("Cannot get goals without a metric id");
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0))).then(checkedUser -> this.leftMapAnErrorResponse(this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false))).then((checkedUser, serviceDesk) -> this.leftMapErrorCollectionResponse("Cannot get goals", this.timeMetricService.getTimeMetric(checkedUser.forJIRA(), (ServiceDesk)serviceDesk, metricId.intValue()))).yield((checkedUser, serviceDesk, timeMetric) -> this.goalService.getAllByTimeMetric(checkedUser.forJIRA(), (ServiceDesk)serviceDesk, (TimeMetric)((Object)timeMetric)));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.map(goals -> this.restResponseHelper.ok((Object)GoalResource.from(goals))));
    }

    @GET
    @Path(value="goals")
    public Response getAll(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0))).then(checkedUser -> this.leftMapAnErrorResponse(this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false))).yield((checkedUser, serviceDesk) -> {
            List<GoalWithTimeMetricId> goals = this.goalService.getAll(checkedUser.forJIRA(), (ServiceDesk)serviceDesk);
            return this.fromWithTimeMetric((CheckedUser)checkedUser, goals);
        });
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.map(arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0)));
    }

    @PUT
    @Path(value="goals/metric/{metricId}")
    public Response updateAll(@PathParam(value="projectKey") String projectKey, @PathParam(value="metricId") Long metricId, GoalsRequest request) {
        if (metricId == null) {
            return this.restResponseHelper.badRequest("Cannot update goals without a metric id");
        }
        return (Response)Eithers.merge((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0))).then(checkedUser -> this.leftMapAnErrorResponse(this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false))).then((checkedUser, serviceDesk) -> this.leftMapErrorCollectionResponse("Cannot update goals", this.timeMetricService.getTimeMetric(checkedUser.forJIRA(), (ServiceDesk)serviceDesk, metricId.intValue()))).then((checkedUser, serviceDesk, timeMetric) -> this.leftMapErrorCollectionResponse("Cannot update goals", this.goalService.updateAll(checkedUser.forJIRA(), (ServiceDesk)serviceDesk, (TimeMetric)((Object)timeMetric), this.from(request)))).yield((checkedUser, serviceDesk, timeMetric, goals) -> this.restResponseHelper.ok((Object)GoalResource.from(goals))));
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapAnErrorResponse(io.atlassian.fugue.Either<AnError, T> either) {
        return either.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0));
    }

    private <T> io.atlassian.fugue.Either<Response, T> leftMapErrorCollectionResponse(String reasonKey2, io.atlassian.fugue.Either<ErrorCollection, T> either) {
        return either.leftMap(errorCollection -> this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)errorCollection).reasonKey(reasonKey2).build()));
    }

    private List<Goal> from(GoalsRequest request) {
        return GoalResource.fromRequest(request.getGoals());
    }

    public static List<Goal> fromRequest(List<GoalRequest> goalRequests) {
        ArrayList<Goal> goals = new ArrayList<Goal>();
        for (GoalRequest goalRequest : goalRequests) {
            goals.add(GoalResource.fromRequest(goalRequest));
        }
        return goals;
    }

    public static Goal fromRequest(GoalRequest goalRequest) {
        return Goal.builder().id(goalRequest.getId()).jqlQuery(goalRequest.getJqlQuery()).duration(goalRequest.getDuration()).defaultGoal(goalRequest.isDefaultGoal()).calendarId(GoalResource.validCalendarId(goalRequest.getCalendarId())).position(goalRequest.getPosition()).build();
    }

    private static Integer validCalendarId(Integer calendarId) {
        return calendarId != null && calendarId > 0 ? calendarId : null;
    }

    public static GoalsResponse from(List<Goal> goals) {
        GoalsResponse response = new GoalsResponse();
        for (Goal goal : goals) {
            response.goals.add(GoalResource.from(goal));
        }
        return response;
    }

    public static GoalResponse from(Goal goal) {
        GoalResponse response = new GoalResponse();
        response.id = goal.getId();
        response.jqlQuery = goal.getJqlQuery();
        response.duration = goal.getDuration();
        response.calendarId = goal.getCalendarId();
        response.defaultGoal = goal.isDefaultGoal();
        return response;
    }

    private GoalsResponse fromWithTimeMetric(CheckedUser checkedUser, List<GoalWithTimeMetricId> goals) {
        GoalsResponse response = new GoalsResponse();
        I18nHelper i18NHelper = checkedUser.i18NHelper();
        for (GoalWithTimeMetricId goal : goals) {
            GoalResponse goalResponse = this.fromWithTimeMetric(goal, i18NHelper);
            response.goals.add(goalResponse);
        }
        return response;
    }

    public GoalResponse fromWithTimeMetric(GoalWithTimeMetricId goal, I18nHelper i18NHelper) {
        GoalResponse response = GoalResource.from(goal);
        response.timeMetricId = goal.getTimeMetricId();
        response.calendarName = this.calendarReferenceService.getReferenceForGoal(goal).getName(i18NHelper);
        return response;
    }
}

