/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.sla;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.sla.response.ConditionResponse;
import com.atlassian.servicedesk.internal.rest.sla.response.ConditionsResponse;
import com.atlassian.servicedesk.internal.sla.condition.ConditionFactoryService;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricHitConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricMatchConditionInfo;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/sla/conditions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ConditionResource {
    private final ConditionFactoryService conditionFactoryService;
    private final ProjectService projectService;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;

    public ConditionResource(ConditionFactoryService conditionFactoryService, ProjectService projectService, RestResponseHelper restResponseHelper, UserFactory userFactory) {
        this.conditionFactoryService = conditionFactoryService;
        this.projectService = projectService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
    }

    @GET
    @Path(value="/available")
    public Response getAll(@PathParam(value="projectKey") String projectKey) {
        if (projectKey == null || projectKey.equals("")) {
            return this.restResponseHelper.badRequest("Metric conditions get all : Project key not specified");
        }
        UncheckedUser user = this.userFactory.getUncheckedUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user.forJIRA(), projectKey);
        if (!projectResult.isValid()) {
            return this.restResponseHelper.validationErrorsToResponse(ValidationErrors.newBuilder((ErrorCollection)projectResult.getErrorCollection()).reasonKey("Cannot load project").build());
        }
        Project project = projectResult.getProject();
        List<TimeMetricMatchConditionInfo> matchConditions = this.conditionFactoryService.getAllMatchConditions(project);
        List<TimeMetricHitConditionInfo> hitConditions = this.conditionFactoryService.getAllHitConditions(project);
        return this.restResponseHelper.ok((Object)this.from((SDUser)user, hitConditions, matchConditions));
    }

    private ConditionsResponse from(SDUser user, List<TimeMetricHitConditionInfo> hitConditions, List<TimeMetricMatchConditionInfo> matchConditions) {
        I18nHelper helper = user.i18NHelper();
        ConditionsResponse response = new ConditionsResponse();
        for (TimeMetricHitConditionInfo hitCondition : hitConditions) {
            response.hitConditions.add(ConditionResource.from(helper, hitCondition));
        }
        for (TimeMetricMatchConditionInfo matchCondition : matchConditions) {
            response.matchConditions.add(ConditionResource.from(helper, matchCondition));
        }
        return response;
    }

    public static ConditionResponse from(I18nHelper helper, TimeMetricHitConditionInfo hitCondition) {
        ConditionResponse result = new ConditionResponse();
        result.pluginKey = hitCondition.getPluginKey();
        result.factoryKey = hitCondition.getConditionFactoryKey();
        result.conditionId = ((TimeMetricHitCondition)hitCondition.getCondition()).getId();
        result.name = ((TimeMetricHitCondition)hitCondition.getCondition()).getName(helper);
        return result;
    }

    public static ConditionResponse from(I18nHelper helper, TimeMetricMatchConditionInfo matchCondition) {
        ConditionResponse result = new ConditionResponse();
        result.pluginKey = matchCondition.getPluginKey();
        result.factoryKey = matchCondition.getConditionFactoryKey();
        result.conditionId = ((TimeMetricMatchCondition)matchCondition.getCondition()).getId();
        result.name = ((TimeMetricMatchCondition)matchCondition.getCondition()).getName(helper);
        return result;
    }
}

