/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.settings.requestsecurity;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.GlobalPublicSignupServiceScala;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsService;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessService;
import com.atlassian.servicedesk.internal.permission.restore.PermissionSchemeMisconfigurationService;
import com.atlassian.servicedesk.internal.rest.settings.requestsecurity.RequestSecuritySettingsResponse;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsConfiguration;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestSecuritySettingsDataProvider {
    @Autowired
    private ParticipantSettingsService participantSettingsService;
    @Autowired
    private UserManager userManager;
    @Autowired
    private PermissionSchemeMisconfigurationService permissionSchemeMisconfigService;
    @Autowired
    private GlobalPublicSignupServiceScala globalPublicSignupService;
    @Autowired
    private InternalServiceDeskService serviceDeskService;
    @Autowired
    private InternalServiceDeskAccessService internalServiceDeskAccessService;
    @Autowired
    private ServiceDeskPermissions serviceDeskPermissions;

    public Either<AnError, RequestSecuritySettingsResponse> getData(CheckedUser user, Project project) {
        Either<AnError, ParticipantSettingsConfiguration> participantSettingsEither = this.participantSettingsService.getSettingsForProject(user, project);
        if (participantSettingsEither.isLeft()) {
            return Either.left((Object)participantSettingsEither.left().get());
        }
        ParticipantSettingsConfiguration participantSettings = (ParticipantSettingsConfiguration)participantSettingsEither.right().get();
        Either serviceDeskEither = this.serviceDeskService.getServiceDeskForProject(user, project, false);
        if (serviceDeskEither.isLeft()) {
            return Either.left((Object)serviceDeskEither.left().get());
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskEither.right().get();
        boolean manageEnabled = participantSettings.getParticipantManagementEnabled();
        boolean autocompleteEnabled = participantSettings.getParticipantAutocompleteEnabled();
        boolean canAdministerJIRA = this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
        boolean readOnlyJIRA = !this.userManager.hasWritableDirectory();
        boolean customerRoleMisconfigured = this.permissionSchemeMisconfigService.isCustomerRoleCriticallyMisconfigured(project);
        boolean globalPublicSignup = this.globalPublicSignupService.isGlobalPublicSignupEnabled();
        boolean serviceDeskOpenAccess = this.internalServiceDeskAccessService.isOpenAccess(serviceDesk);
        boolean serviceDeskPublicSignup = this.internalServiceDeskAccessService.isProjectLevelSignupSettingEnabled(serviceDesk);
        RequestSecuritySettingsResponse result = new RequestSecuritySettingsResponse(manageEnabled, autocompleteEnabled, canAdministerJIRA, readOnlyJIRA, customerRoleMisconfigured, globalPublicSignup, serviceDeskOpenAccess, serviceDeskPublicSignup);
        return Either.right((Object)result);
    }
}

