/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.settings.language;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInput;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInputBuilder;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInputBuilderFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.settings.language.ManageLanguageHelper;
import com.atlassian.servicedesk.internal.rest.settings.language.request.LanguageUpdateListRequest;
import java.util.Locale;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/manage-language/{projectId}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ManageLanguageResource {
    private final ErrorResultHelper errorResultHelper;
    private final UserFactory userFactory;
    private final ProjectService projectService;
    private final FeatureManager featureManager;
    private final RestResponseHelper restResponseHelper;
    private final ManageLanguageHelper notificationManageLanguageHelper;
    private final LingoProjectLanguageInputBuilderFactory lingoProjectLanguageInputBuilderFactory;

    public ManageLanguageResource(ErrorResultHelper errorResultHelper, UserFactory userFactory, ProjectService projectService, FeatureManager featureManager, RestResponseHelper restResponseHelper, ManageLanguageHelper notificationManageLanguageHelper, LingoProjectLanguageInputBuilderFactory lingoProjectLanguageInputBuilderFactory) {
        this.errorResultHelper = errorResultHelper;
        this.userFactory = userFactory;
        this.projectService = projectService;
        this.featureManager = featureManager;
        this.restResponseHelper = restResponseHelper;
        this.notificationManageLanguageHelper = notificationManageLanguageHelper;
        this.lingoProjectLanguageInputBuilderFactory = lingoProjectLanguageInputBuilderFactory;
    }

    @GET
    public Response getLanguages(@PathParam(value="projectId") long projectId) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.NOTIFICATION_MANAGE_LANGUAGE)) {
            return this.featureNotEnabledResponse();
        }
        io.atlassian.fugue.Either resultEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveProjectForUser(user.forJIRA(), projectId)).then(this.notificationManageLanguageHelper::retrieveLanguageResponse).yield((user, project, languageResponse) -> languageResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(resultEither);
    }

    @POST
    public Response storeLanguages(@PathParam(value="projectId") long projectId, LanguageUpdateListRequest request) {
        io.atlassian.fugue.Either resultEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveProjectForUser(user.forJIRA(), projectId)).then((user, project) -> this.buildLingoProjectLanguageInput(projectId, request)).then(this.notificationManageLanguageHelper::storeLanguages).yield((user, project, input, languageResponse) -> languageResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(resultEither);
    }

    private Response featureNotEnabledResponse() {
        return Response.status((int)412).build();
    }

    private io.atlassian.fugue.Either<AnError, Project> retrieveProjectForUser(ApplicationUser applicationUser, long projectId) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectById(applicationUser, Long.valueOf(projectId));
        if (!getProjectResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.error.project.not.found", new Object[]{projectId}).build());
        }
        return io.atlassian.fugue.Either.right((Object)getProjectResult.getProject());
    }

    private io.atlassian.fugue.Either<AnError, LingoProjectLanguageInput> buildLingoProjectLanguageInput(long projectId, LanguageUpdateListRequest request) {
        Locale defaultLocale = Locale.forLanguageTag(request.getProjectDefaultLanguageKey());
        LingoProjectLanguageInputBuilder builder = this.lingoProjectLanguageInputBuilderFactory.newBuilder(projectId);
        builder.defaultLanguage(defaultLocale);
        request.getLanguages().forEach(language -> builder.addLanguage(Locale.forLanguageTag(language.getLanguageTag()), language.isEnabled()));
        return builder.build();
    }
}

