/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.settings.language;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInput;
import com.atlassian.servicedesk.internal.feature.language.ManageLanguageService;
import com.atlassian.servicedesk.internal.rest.settings.language.response.LanguageListResponse;
import com.atlassian.servicedesk.internal.rest.settings.language.response.LanguageResponse;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ManageLanguageHelper {
    private static final List<String> LANGUAGE_STATES_ORDER = ImmutableList.of((Object)LanguageResponse.LanguageState.ACTIVE.toString(), (Object)LanguageResponse.LanguageState.INACTIVE.toString(), (Object)LanguageResponse.LanguageState.UNUSED.toString());
    private final LocaleManager localeManager;
    private final ManageLanguageService manageLanguageService;

    @Autowired
    ManageLanguageHelper(LocaleManager localeManager, ManageLanguageService manageLanguageService) {
        this.localeManager = localeManager;
        this.manageLanguageService = manageLanguageService;
    }

    Either<AnError, LanguageListResponse> retrieveLanguageResponse(CheckedUser user, Project project) {
        return this.manageLanguageService.getProjectLanguageConfiguration(user, project).map(lingoConfig -> this.toLanguageListResponse(user, (LingoProjectConfiguration)lingoConfig));
    }

    Either<AnError, LanguageListResponse> storeLanguages(CheckedUser user, Project project, LingoProjectLanguageInput input) {
        return this.manageLanguageService.storeProjectConfiguration(user, project, input).map(lingoConfig -> this.toLanguageListResponse(user, (LingoProjectConfiguration)lingoConfig));
    }

    private LanguageListResponse toLanguageListResponse(CheckedUser user, LingoProjectConfiguration lingoConfig) {
        HashMap<Locale, LanguageResponse.LanguageState> languageStates = new HashMap<Locale, LanguageResponse.LanguageState>();
        lingoConfig.getLanguages().forEach(language -> {
            Locale locale = language.getLocale();
            LanguageResponse.LanguageState languageState = language.isActive() ? LanguageResponse.LanguageState.ACTIVE : LanguageResponse.LanguageState.INACTIVE;
            languageStates.put(locale, languageState);
        });
        this.localeManager.getInstalledLocales().forEach(locale -> languageStates.putIfAbsent((Locale)locale, LanguageResponse.LanguageState.UNUSED));
        Locale projectDefaultLocale = lingoConfig.getProjectDefaultLocale();
        return new LanguageListResponse(this.toSortedResponseList(user, languageStates, projectDefaultLocale), projectDefaultLocale.toLanguageTag());
    }

    private List<LanguageResponse> toSortedResponseList(CheckedUser user, Map<Locale, LanguageResponse.LanguageState> languageStates, Locale defaultLocale) {
        return languageStates.entrySet().stream().map(entry -> this.toLanguageResponse(user, (Map.Entry<Locale, LanguageResponse.LanguageState>)entry)).sorted(this.buildLanguageComparator(defaultLocale)).collect(Collectors.toList());
    }

    private Comparator<LanguageResponse> buildLanguageComparator(Locale defaultLocale) {
        String defaultLocaleKey = defaultLocale.toLanguageTag();
        Comparator isDefaultLangComparator = (first, second) -> {
            if (first.getKey().equals(defaultLocaleKey)) {
                return -1;
            }
            if (second.getKey().equals(defaultLocaleKey)) {
                return 1;
            }
            return 0;
        };
        return isDefaultLangComparator.thenComparingInt(language -> LANGUAGE_STATES_ORDER.indexOf(language.getState())).thenComparing(LanguageResponse::getLabel);
    }

    private LanguageResponse toLanguageResponse(CheckedUser user, Map.Entry<Locale, LanguageResponse.LanguageState> languageStateEntry) {
        Locale locale = languageStateEntry.getKey();
        return new LanguageResponse(locale.toLanguageTag(), this.getLocaleLabelForUser(user, locale), languageStateEntry.getValue());
    }

    private String getLocaleLabelForUser(CheckedUser user, Locale locale) {
        return locale.getDisplayName(user.i18NHelper().getLocale());
    }
}

