/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.settings.announcement;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="{projectKey}/settings/agent-announcements")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AgentsManagePortalAnnouncementResource {
    private final AnnouncementService announcementService;
    private final PortalService portalService;
    private final RestResponseHelper restResponseHelper;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final UserFactory userFactory;

    @Autowired
    public AgentsManagePortalAnnouncementResource(AnnouncementService announcementService, PortalService portalService, RestResponseHelper restResponseHelper, ServiceDeskProjectService serviceDeskProjectService, UserFactory userFactory) {
        this.announcementService = announcementService;
        this.portalService = portalService;
        this.restResponseHelper = restResponseHelper;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.userFactory = userFactory;
    }

    @GET
    public Response getState(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user.forJIRA(), project)).map(portal -> portal)).yield((user, project, portal) -> this.announcementService.canAgentsManagePortalAnnouncement((Portal)portal));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="/enable")
    public Response enableProjectSetting(@PathParam(value="projectKey") String projectKey) {
        return this.setCanAgentsManagePortalAnnouncement(projectKey, true);
    }

    @PUT
    @Path(value="/disable")
    public Response disableProjectSetting(@PathParam(value="projectKey") String projectKey) {
        return this.setCanAgentsManagePortalAnnouncement(projectKey, false);
    }

    private Response setCanAgentsManagePortalAnnouncement(String projectKey, boolean enabled) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user.forJIRA(), project))).then((user, project, portal) -> this.announcementService.setCanAgentsManagePortalAnnouncement((CheckedUser)user, (Portal)portal, (Project)project, enabled)).yield((user, project, portal, canManage) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }
}

