/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.settings.announcement;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/admin/agent-announcements")
@Consumes(value={"application/json"})
public class AgentsManageHelpCenterAnnouncementResource {
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final AnnouncementService announcementService;

    public AgentsManageHelpCenterAnnouncementResource(AnnouncementService announcementService, RestResponseHelper restResponseHelper, UserFactory userFactory) {
        this.announcementService = announcementService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
    }

    @GET
    public Response getState() {
        return Response.ok((Object)this.announcementService.canAgentsManageHelpCenterAnnouncement()).build();
    }

    @PUT
    @Path(value="/enable")
    public Response enableAgentsManageHelpCenterAnnouncement() {
        return this.setAgentsManageHelpCenterAnnouncement(true);
    }

    @PUT
    @Path(value="/disable")
    public Response disableAgentsManageHelpCenterAnnouncement() {
        return this.setAgentsManageHelpCenterAnnouncement(false);
    }

    private Response setAgentsManageHelpCenterAnnouncement(boolean enabled) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.announcementService.setCanAgentsManageHelpCenterAnnouncement((CheckedUser)user, enabled)).yield((user, canManage) -> canManage);
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }
}

