/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.settings;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseInternalService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.web.pagedata.settings.KnowledgeBaseSettingsPageDataProvider;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="pages/settings/kb/{projectKey}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class KnowledgeBaseSettingsPageResource {
    private final UserFactory userFactory;
    private final KnowledgeBaseSettingsPageDataProvider kbDataProvider;
    private final ServiceDeskProjectService sdProjectService;
    private final ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService;
    private final RestResponseHelper restResponseHelper;

    public KnowledgeBaseSettingsPageResource(UserFactory userFactory, KnowledgeBaseSettingsPageDataProvider kbDataProvider, ServiceDeskProjectService sdProjectService, ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.kbDataProvider = kbDataProvider;
        this.sdProjectService = sdProjectService;
        this.confluenceKnowledgeBaseInternalService = confluenceKnowledgeBaseInternalService;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response getKnowledgeBaseSettings(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.kbDataProvider.getData((CheckedUser)user, (Project)project)).yield((user, project, link) -> link);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @DELETE
    public Response deleteKBLink(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.confluenceKnowledgeBaseInternalService.deleteKBLink(user, project)).then((user, project, unit) -> this.kbDataProvider.getData((CheckedUser)user, (Project)project)).yield((user, project, unit, link) -> link);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }
}

