/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses;

import com.atlassian.servicedesk.internal.rest.responses.RequestTypeSelectItem;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PortalRequestTypes
implements Comparable<PortalRequestTypes> {
    private String id;
    private String name;
    private Set<RequestTypeSelectItem> requestTypes;

    public PortalRequestTypes(String id, String name) {
        this.id = id;
        this.name = name;
        this.requestTypes = Sets.newHashSet();
    }

    public void addRequestType(String requestTypeId, String requestTypeName, Long requestTypeIcon) {
        RequestTypeSelectItem requestType = new RequestTypeSelectItem(requestTypeId, requestTypeName, requestTypeIcon);
        if (!this.requestTypes.contains(requestType)) {
            this.requestTypes.add(requestType);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PortalRequestTypes)) {
            return false;
        }
        PortalRequestTypes item = (PortalRequestTypes)obj;
        return StringUtils.equals((String)item.id, (String)this.id);
    }

    public String getId() {
        return this.id;
    }

    public Set<RequestTypeSelectItem> getRequestTypes() {
        return this.requestTypes;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    @Override
    public int compareTo(PortalRequestTypes prt) {
        return this.name.compareTo(prt.name);
    }
}

