/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.rest.responses.AppLinkConfiguredAuthentication;
import com.atlassian.servicedesk.internal.rest.responses.AppLinkError;
import com.atlassian.servicedesk.internal.rest.responses.AppLinkResponse;
import com.atlassian.servicedesk.plugins.coreui.internal.utils.HelpUrlHelper;

public class AppLinkResponseHelper {
    public static AppLinkResponse buildValidAppLinkResponse(Boolean impersonationStatus, HelpUrlHelper helpUrlHelper, ApplicationLink appLink, Class<? extends AuthenticationProvider> authClass) {
        return AppLinkResponse.builder().appLinkId(appLink.getId().get()).displayUrl(appLink.getDisplayUrl().toString()).name(appLink.getName()).requestUrl(appLink.getRpcUrl().toString()).appLinkHelpLink(helpUrlHelper.getStaticLinks().getUrl("applinks").getUrl()).authType(new AppLinkConfiguredAuthentication(authClass.getName(), impersonationStatus)).appLinkError(AppLinkResponseHelper.createAppLinkErrorForValidLink()).isPrimary(appLink.isPrimary()).build();
    }

    public static AppLinkResponse buildInvalidAppLinkResponse(HelpUrlHelper helpUrlHelper, ErrorTranslationHelper errorTranslationHelper, ApplicationLink appLink, AnError error, I18nHelper i18nHelper) {
        return AppLinkResponse.builder().appLinkId(appLink.getId().get()).displayUrl(appLink.getDisplayUrl().toString()).name(appLink.getName()).requestUrl(appLink.getRpcUrl().toString()).appLinkHelpLink(helpUrlHelper.getStaticLinks().getUrl("applinks").getUrl()).authType(new AppLinkConfiguredAuthentication("", false)).appLinkError(AppLinkResponseHelper.buildAppLinkError(errorTranslationHelper, error, i18nHelper)).build();
    }

    private static AppLinkError createAppLinkErrorForValidLink() {
        return new AppLinkError(true, "", false);
    }

    private static AppLinkError buildAppLinkError(ErrorTranslationHelper errorTranslationHelper, AnError error, I18nHelper i18nHelper) {
        String errorMessageString = errorTranslationHelper.translateAnError(error, i18nHelper);
        return new AppLinkError(false, errorMessageString, false);
    }
}

