/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses;

import com.atlassian.servicedesk.internal.rest.responses.AppLinkConfiguredAuthentication;
import com.atlassian.servicedesk.internal.rest.responses.AppLinkError;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class AppLinkResponse {
    private final String appLinkId;
    private final String displayUrl;
    private final String name;
    private final String requestUrl;
    private final String appLinkHelpLink;
    private final AppLinkConfiguredAuthentication authType;
    private final AppLinkError appLinkError;
    private final boolean isPrimary;

    public AppLinkResponse(String appLinkId, String displayUrl, String name, String requestUrl, String appLinkHelpLink, AppLinkConfiguredAuthentication authType, AppLinkError appLinkError, boolean isPrimary) {
        this.appLinkId = appLinkId;
        this.displayUrl = displayUrl;
        this.name = name;
        this.requestUrl = requestUrl;
        this.appLinkHelpLink = appLinkHelpLink;
        this.authType = authType;
        this.appLinkError = appLinkError;
        this.isPrimary = isPrimary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAppLinkId() {
        return this.appLinkId;
    }

    public String getDisplayUrl() {
        return this.displayUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getAppLinkHelpLink() {
        return this.appLinkHelpLink;
    }

    public AppLinkConfiguredAuthentication getAuthType() {
        return this.authType;
    }

    public AppLinkError getAppLinkError() {
        return this.appLinkError;
    }

    public boolean getIsPrimary() {
        return this.isPrimary;
    }

    public static class Builder {
        private String appLinkId;
        private String displayUrl;
        private String name;
        private String requestUrl;
        private String appLinkHelpLink;
        private AppLinkConfiguredAuthentication authType;
        private AppLinkError appLinkError;
        private boolean isPrimary = false;

        public Builder appLinkId(String appLinkId) {
            this.appLinkId = appLinkId;
            return this;
        }

        public Builder displayUrl(String displayUrl) {
            this.displayUrl = displayUrl;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder requestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
            return this;
        }

        public Builder appLinkHelpLink(String appLinkHelpLink) {
            this.appLinkHelpLink = appLinkHelpLink;
            return this;
        }

        public Builder authType(AppLinkConfiguredAuthentication authType) {
            this.authType = authType;
            return this;
        }

        public Builder appLinkError(AppLinkError appLinkError) {
            this.appLinkError = appLinkError;
            return this;
        }

        public Builder isPrimary(boolean primary) {
            this.isPrimary = primary;
            return this;
        }

        public AppLinkResponse build() {
            return new AppLinkResponse(this.appLinkId, this.displayUrl, this.name, this.requestUrl, this.appLinkHelpLink, this.authType, this.appLinkError, this.isPrimary);
        }
    }
}

