/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.responses;

import com.atlassian.servicedesk.internal.rest.responses.AgentResponse;
import com.atlassian.servicedesk.internal.rest.responses.AgentResultsResponse;
import com.atlassian.servicedesk.internal.rest.responses.AgentWorkloadDetails;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class AgentResultsPaginationResponse
extends AgentResultsResponse {
    private final int pageNumber;
    private final int resultsPerPage;
    private final int pageRange;

    public AgentResultsPaginationResponse(String query, int total, int pageNumber, int resultsPerPage, int pageRange, List<AgentResponse> results, Map<String, AgentWorkloadDetails> agentWorkloads) {
        super(query, total, results, agentWorkloads);
        this.pageNumber = pageNumber;
        this.resultsPerPage = resultsPerPage;
        this.pageRange = pageRange;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public int getPageRange() {
        return this.pageRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AgentResultsPaginationResponse other = (AgentResultsPaginationResponse)obj;
        return Objects.equals(this.pageNumber, other.pageNumber) && Objects.equals(this.resultsPerPage, other.resultsPerPage) && Objects.equals(this.pageRange, other.pageRange) && Objects.equals(this.getQuery(), other.getQuery()) && Objects.equals(this.getTotal(), other.getTotal()) && Objects.equals(this.getResults(), other.getResults()) && Objects.equals(this.getAgentWorkloads(), other.getAgentWorkloads());
    }

    public int hashCode() {
        int result = this.getAgentWorkloads().hashCode();
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.resultsPerPage;
        result = 31 * result + this.pageRange;
        result = 31 * result + this.getQuery().hashCode();
        result = 31 * result + this.getTotal();
        result = 31 * result + this.getResults().hashCode();
        return result;
    }
}

