/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group.hidden;

import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeCreateRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeUpdateRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeCreateRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeDeleteRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeGetRequestHandler;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeUpdateRequestHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectId}/request-type-groups/hidden")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class HiddenRequestTypeGroupResource {
    private final RequestTypeCreateRequestHandler requestTypeCreator;
    private final RequestTypeGetRequestHandler requestTypeFetcher;
    private final RequestTypeUpdateRequestHandler requestTypeUpdateRequestHandler;
    private final RequestTypeDeleteRequestHandler requestTypeDeleteRequestHandler;

    public HiddenRequestTypeGroupResource(RequestTypeCreateRequestHandler requestTypeCreator, RequestTypeGetRequestHandler requestTypeResponseCreator, RequestTypeUpdateRequestHandler requestTypeUpdateRequestHandler, RequestTypeDeleteRequestHandler requestTypeDeleteRequestHandler) {
        this.requestTypeUpdateRequestHandler = requestTypeUpdateRequestHandler;
        this.requestTypeCreator = requestTypeCreator;
        this.requestTypeFetcher = requestTypeResponseCreator;
        this.requestTypeDeleteRequestHandler = requestTypeDeleteRequestHandler;
    }

    @GET
    @Path(value="/request-types/{id}")
    public Response getRequestType(@PathParam(value="projectId") Long projectId, @PathParam(value="id") Integer requestTypeId) {
        return this.requestTypeFetcher.getRequestType(projectId, requestTypeId);
    }

    @GET
    @Path(value="/request-types/")
    public Response getRequestType(@PathParam(value="projectId") Long projectId) {
        return this.requestTypeFetcher.getAllHiddenRequestTypes(projectId);
    }

    @POST
    @Path(value="/request-types")
    public Response createHiddenRequestType(@PathParam(value="projectId") long projectId, RequestTypeCreateRequest request) {
        return this.requestTypeCreator.createHiddenRequestType(projectId, request);
    }

    @PUT
    @Path(value="/request-types/{id}")
    public Response updateRequestType(@PathParam(value="projectId") Long projectId, @PathParam(value="id") Integer requestTypeId, RequestTypeUpdateRequest request) {
        return this.requestTypeUpdateRequestHandler.updateRequestType(projectId, requestTypeId, request);
    }

    @DELETE
    @Path(value="/request-types/{id}")
    public Response deleteRequestType(@PathParam(value="projectId") Long projectId, @PathParam(value="id") Integer requestTypeId) {
        return this.requestTypeDeleteRequestHandler.deleteRequestType(projectId, requestTypeId);
    }
}

