/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group.handler;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeGroupDTO;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeResponse;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeResponseHandler {
    private final RichTextRenderer textRenderer;
    private final IssueTypeManager issueTypeManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final RequestTypeInternalService requestTypeInternalService;

    @Autowired
    public RequestTypeResponseHandler(RichTextRenderer textRenderer, IssueTypeManager issueTypeManager, JiraBaseUrls jiraBaseUrls, RequestTypeInternalService requestTypeInternalService) {
        this.textRenderer = textRenderer;
        this.issueTypeManager = issueTypeManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.requestTypeInternalService = requestTypeInternalService;
    }

    public Response requestType(RequestType requestType, long projectId) {
        return Response.ok((Object)this.map(requestType, projectId)).build();
    }

    public Response requestTypes(List<RequestType> requestTypes, long projectId) {
        return Response.ok(requestTypes.stream().map(rt -> this.map((RequestType)rt, projectId)).collect(Collectors.toList())).build();
    }

    private RequestTypeResponse map(RequestType requestType, long projectId) {
        return new RequestTypeResponse(requestType.getId(), requestType.getIconId(), requestType.getName(), this.createIssueType(requestType), requestType.getDescription(), this.textRenderer.renderWiki(requestType.getDescription(), RenderOption.OPEN_LINKS_IN_NEW_TAB), this.createGroups(requestType), 0, projectId, (Boolean)this.requestTypeInternalService.isUsedByEmail(requestType).right().get(), requestType.getHelpText(), this.textRenderer.renderWiki(requestType.getHelpText(), RenderOption.OPEN_LINKS_IN_NEW_TAB));
    }

    private IssueTypeJsonBean createIssueType(RequestType requestType) {
        IssueType issueType = this.issueTypeManager.getIssueType(requestType.getIssueTypeId() + "");
        return IssueTypeJsonBean.shortBean((IssueType)issueType, (JiraBaseUrls)this.jiraBaseUrls);
    }

    private List<RequestTypeGroupDTO> createGroups(RequestType requestType) {
        return requestType.getGroups().stream().map(group -> new RequestTypeGroupDTO(group.getId(), group.getName())).collect(Collectors.toList());
    }
}

