/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group.handler;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeGroupDeleteConfirmationResponse;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeResponseHandler;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeGetRequestHandler {
    private final RequestTypeResponseHandler requestTypeResponseHandler;
    private final RequestTypeService requestTypeService;
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final RequestTypeGroupService requestTypeGroupService;
    private final InternalPortalService internalPortalService;
    private final InternalServiceDeskService serviceDeskService;
    private final RestResponseHelper restResponseHelper;

    @Autowired
    public RequestTypeGetRequestHandler(RequestTypeResponseHandler requestTypeResponseHandler, RequestTypeService requestTypeService, UserFactory userFactory, ServiceDeskProjectService serviceDeskProjectService, RequestTypeInternalService requestTypeInternalService, RequestTypeGroupService requestTypeGroupService, InternalPortalService internalPortalService, InternalServiceDeskService serviceDeskService, RestResponseHelper restResponseHelper) {
        this.requestTypeResponseHandler = requestTypeResponseHandler;
        this.requestTypeService = requestTypeService;
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.requestTypeInternalService = requestTypeInternalService;
        this.requestTypeGroupService = requestTypeGroupService;
        this.internalPortalService = internalPortalService;
        this.serviceDeskService = serviceDeskService;
        this.restResponseHelper = restResponseHelper;
    }

    public Response getGroupDeleteConfirmation(long projectId, int groupId) {
        return (Response)this.getRequestTypeGroupDeleteConfirmationResponse(projectId, groupId).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), deleteConfirmResponse -> Response.ok((Object)deleteConfirmResponse).build());
    }

    public Response getRequestType(Long projectId, Integer requestTypeId) {
        return (Response)this.requestTypeService.getRequestTypeByIdAndProjectId(requestTypeId, projectId).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestType -> this.requestTypeResponseHandler.requestType((RequestType)requestType, projectId));
    }

    public Response getAllHiddenRequestTypes(Long projectId) {
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, projectId)).then((checkedUser, project) -> this.serviceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((arg_0, arg_1, arg_2) -> ((RequestTypeInternalService)this.requestTypeInternalService).getHiddenRequestTypes(arg_0, arg_1, arg_2)).yield((checkedUser, project, sd, requestTypes) -> requestTypes).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestTypes -> this.requestTypeResponseHandler.requestTypes((List<RequestType>)requestTypes, projectId));
    }

    public Response getAllRequestTypesInGroup(long projectId, int groupId) {
        return (Response)this.requestTypeService.getRequestTypesForGroup(Integer.valueOf(groupId), Long.valueOf(projectId)).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestTypes -> this.requestTypeResponseHandler.requestTypes((List<RequestType>)requestTypes, projectId));
    }

    public Response getAllRequestTypesNotInGroup(long projectId, int groupId) {
        return (Response)this.requestTypeInternalService.getRequestTypesNotInGroup(projectId, groupId).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestTypes -> this.requestTypeResponseHandler.requestTypes((List<RequestType>)requestTypes, projectId));
    }

    private io.atlassian.fugue.Either<AnError, RequestTypeGroupDeleteConfirmationResponse> getRequestTypeGroupDeleteConfirmationResponse(long projectId, int groupId) {
        io.atlassian.fugue.Either groupResult = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, projectId)).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeGroupService.getGroup(checkedUser, project, portal, groupId)).yield((checkedUser, project, portal, group) -> group);
        return Steps.begin((io.atlassian.fugue.Either)groupResult).then(group -> this.requestTypeInternalService.getRequestTypesOnlyInGroup(projectId, groupId)).then((group, requestTypesOnlyInGroup) -> StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypesForGroup(Integer.valueOf(groupId), Long.valueOf(projectId)))).yield((group, requestTypesOnlyInGroup, requestTypesInGroup) -> new RequestTypeGroupDeleteConfirmationResponse(requestTypesOnlyInGroup.size(), group.getName(), requestTypesInGroup.size()));
    }
}

