/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.requesttype.group.handler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.CreateRequestTypeParams;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.CreateRequestTypeValidationResult;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeModificationService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requesttype.group.RequestTypeCreateRequest;
import com.atlassian.servicedesk.internal.rest.requesttype.group.handler.RequestTypeResponseHandler;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeCreateRequestHandler {
    private final RequestTypeModificationService requestTypeModificationService;
    private final InternalPortalService internalPortalService;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final UserFactory userFactory;
    private final RequestTypeResponseHandler requestTypeResponseHandler;
    private final RestResponseHelper restResponseHelper;

    @Autowired
    public RequestTypeCreateRequestHandler(RequestTypeModificationService requestTypeModificationService, InternalPortalService internalPortalService, ServiceDeskProjectService serviceDeskProjectService, UserFactory userFactory, RequestTypeResponseHandler requestTypeResponseHandler, RestResponseHelper restResponseHelper) {
        this.requestTypeModificationService = requestTypeModificationService;
        this.internalPortalService = internalPortalService;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.userFactory = userFactory;
        this.requestTypeResponseHandler = requestTypeResponseHandler;
        this.restResponseHelper = restResponseHelper;
    }

    public Response createHiddenRequestType(long projectId, RequestTypeCreateRequest request) {
        return this.createRequestTypeInGroup(projectId, request, null);
    }

    public Response createRequestTypeInGroup(long projectId, RequestTypeCreateRequest request, @Nullable Integer groupId) {
        return (Response)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskProjectService.getProjectById((CheckedUser)checkedUser, projectId)).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.requestTypeModificationService.validateCreateRequestType(this.map(request, (Portal)portal, groupId), (Project)project)).yield((checkedUser, project, portal, validationResult) -> validationResult).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), validationResult -> this.handleCreateValidationResult((CreateRequestTypeValidationResult)validationResult, projectId));
    }

    private Response handleCreateValidationResult(CreateRequestTypeValidationResult validationResult, long projectId) {
        if (validationResult.isValid()) {
            return (Response)this.requestTypeModificationService.createRequestType(validationResult).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), requestType -> this.requestTypeResponseHandler.requestType((RequestType)requestType, projectId));
        }
        return this.restResponseHelper.namedErrorsToResponse(validationResult.getNamedErrors());
    }

    private CreateRequestTypeParams map(RequestTypeCreateRequest request, Portal portal, Integer groupId) {
        return new CreateRequestTypeParams(portal.getId(), request.getIcon(), request.getIssueType(), request.getName(), request.getDescription(), "", request.getOrder(), groupId);
    }
}

