/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.reports.workload;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.reports.workload.WorkloadPageDataProvider;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="pages/people/agents/{projectKey}")
public class WorkloadPageResource {
    private final WorkloadPageDataProvider workloadPageDataProvider;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;

    public WorkloadPageResource(WorkloadPageDataProvider workloadPageDataProvider, ServiceDeskProjectService serviceDeskProjectService, UserFactory userFactory, RestResponseHelper restResponseHelper) {
        this.workloadPageDataProvider = workloadPageDataProvider;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response getWorkloadPage(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.workloadPageDataProvider::getData).yield((user, project, response) -> response);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/search")
    public Response searchAgents(@PathParam(value="projectKey") String projectKey, @QueryParam(value="query") String query, @QueryParam(value="page") @DefaultValue(value="1") int pageNumber) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.workloadPageDataProvider.searchAgents((CheckedUser)user, (Project)project, query, pageNumber)).yield((user, project, response) -> response);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }
}

