/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.reports.workload;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.internal.feature.people.AgentWithIssuesCount;
import com.atlassian.servicedesk.internal.feature.people.AgentWorkloadService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.reports.workload.WorkloadPageDataProvider;
import com.atlassian.servicedesk.internal.rest.responses.AgentResponse;
import com.atlassian.servicedesk.internal.rest.responses.AgentResultsPaginationResponse;
import com.atlassian.servicedesk.internal.rest.responses.AgentResultsResponse;
import com.atlassian.servicedesk.internal.rest.responses.WorkloadPageResponse;
import com.atlassian.servicedesk.internal.rest.util.WorkloadPaginationHelper;
import com.atlassian.servicedesk.internal.web.pagedata.AgentEntityBuilder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkloadPageDataProviderImpl
implements WorkloadPageDataProvider {
    private static final int AGENT_TAB_MAXIMUM_USERS = 20;
    private final ServiceDeskService serviceDeskService;
    private final AgentWorkloadService agentWorkloadService;
    private final AgentEntityBuilder agentEntityBuilder;
    private final WorkloadPaginationHelper workloadPaginationHelper;
    private final FeatureManager featureManager;

    @Autowired
    public WorkloadPageDataProviderImpl(ServiceDeskService serviceDeskService, AgentWorkloadService agentWorkloadService, AgentEntityBuilder agentEntityBuilder, WorkloadPaginationHelper workloadPaginationHelper, FeatureManager featureManager) {
        this.serviceDeskService = serviceDeskService;
        this.agentWorkloadService = agentWorkloadService;
        this.agentEntityBuilder = agentEntityBuilder;
        this.workloadPaginationHelper = workloadPaginationHelper;
        this.featureManager = featureManager;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, WorkloadPageResponse> getData(CheckedUser user, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then(serviceDesk -> this.agentWorkloadService.getAgentsWithUnresolvedIssueCountSortedByHighestCountFirst(user, (ServiceDesk)serviceDesk, project)).yield((serviceDesk, agents) -> {
            Integer maxCount = agents.stream().findFirst().map(AgentWithIssuesCount::getIssuesCount).orElse(0);
            return new WorkloadPageResponse(project.getId(), project.getName(), maxCount);
        });
    }

    @Override
    public io.atlassian.fugue.Either<AnError, AgentResultsResponse> searchAgents(CheckedUser user, Project project, String query, int pageNumber) {
        if (pageNumber < 1) {
            ErrorMessage errorMessage = ErrorMessage.builder().message(pageNumber + " is an invalid page number").build();
            return io.atlassian.fugue.Either.left((Object)new AnError(errorMessage, 404));
        }
        if (this.featureManager.isEnabled(SDFeatureFlags.WORKLOAD_REPORT_PAGINATOR)) {
            int blockSize = this.workloadPaginationHelper.getFetchBlockSize();
            int maxPages = this.workloadPaginationHelper.getMaximumPagesToShow();
            LimitedPagedRequest searchPageRequest = this.workloadPaginationHelper.createSearchPageRequest(pageNumber, blockSize);
            return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then(serviceDesk -> this.agentWorkloadService.getFilteredAgentsWithWorkloadDetails(user, (ServiceDesk)serviceDesk, project, query, searchPageRequest)).then((serviceDesk, agentWorkloadSearchResults) -> this.agentEntityBuilder.buildAgentResponses(agentWorkloadSearchResults.getTopAgents())).yield((serviceDesk, agentWorkloadSearchResults, agentResponses) -> new AgentResultsPaginationResponse(query, agentWorkloadSearchResults.getTotalMatchedAgents(), pageNumber, blockSize, maxPages, (List<AgentResponse>)agentResponses, agentWorkloadSearchResults.getAgentToWorkloadDetails()));
        }
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then(serviceDesk -> this.agentWorkloadService.getFilteredAgentsWithWorkloadDetails(user, (ServiceDesk)serviceDesk, project, query, 20)).then((serviceDesk, agentWorkloadSearchResults) -> this.agentEntityBuilder.buildAgentResponses(agentWorkloadSearchResults.getTopAgents())).yield((serviceDesk, agentWorkloadSearchResults, agentResponses) -> new AgentResultsResponse(query, agentWorkloadSearchResults.getTotalMatchedAgents(), (List<AgentResponse>)agentResponses, agentWorkloadSearchResults.getAgentToWorkloadDetails()));
    }
}

