/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.rendering;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Eithers;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/servicedesk/rendering")
public class TextRendererResource {
    private final RichTextRenderer richTextRenderer;
    private final UserFactory userFactory;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ErrorResultHelper errorHelper;
    private final RestResponseHelper restResponseHelper;

    protected TextRendererResource(RichTextRenderer richTextRenderer, ServiceDeskPermissions serviceDeskPermissions, UserFactory userFactory, ErrorResultHelper errorHelper, RestResponseHelper restResponseHelper) {
        this.richTextRenderer = richTextRenderer;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.userFactory = userFactory;
        this.errorHelper = errorHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"text/plain"})
    @Path(value="/wiki")
    public Response getWikiRenderedText(@QueryParam(value="linksInNewTab") String linksInNewTabString, String text) {
        io.atlassian.fugue.Either yield = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> {
            if (!this.serviceDeskPermissions.canAccessJIRA((SDUser)user)) {
                return io.atlassian.fugue.Either.left((Object)this.errorHelper.forbidden403("sd.error.wiki.render.forbidden", new Object[0]).build());
            }
            return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
        }).yield((user, success) -> {
            if (StringUtils.isBlank((String)text)) {
                return this.restResponseHelper.ok((Object)"");
            }
            return this.restResponseHelper.ok((Object)this.renderText(text, Boolean.valueOf(linksInNewTabString)));
        });
        return (Response)Eithers.merge((io.atlassian.fugue.Either)yield.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    private String renderText(String text, boolean linksInNewTab) {
        return linksInNewTab ? this.richTextRenderer.renderWiki(text, RenderOption.OPEN_LINKS_IN_NEW_TAB) : this.richTextRenderer.renderWiki(text, new RenderOption[0]);
    }
}

