/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.queues;

import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.issue.issuelist.IssueListService;
import com.atlassian.servicedesk.internal.issue.issuelist.ServiceDeskIssueList;
import com.atlassian.servicedesk.internal.issue.issuelist.views.IssueListColumnView;
import com.atlassian.servicedesk.internal.issue.issuelist.views.IssueListFieldView;
import com.atlassian.servicedesk.internal.issue.issuelist.views.IssueListIssueView;
import com.atlassian.servicedesk.internal.issue.issuelist.views.ServiceDeskIssueListView;
import com.atlassian.servicedesk.internal.rest.queues.response.IssueColumnResponse;
import com.atlassian.servicedesk.internal.rest.queues.response.IssueFieldResponse;
import com.atlassian.servicedesk.internal.rest.queues.response.IssueListResponse;
import com.atlassian.servicedesk.internal.rest.queues.response.IssueRowResponse;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/issuelist")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueListResource {
    private UserFactory userFactory;
    private IssueListService issueListService;
    private InternalServiceDeskService serviceDeskService;
    private final ErrorResultHelper errorHelper;
    private final RestResponseHelper restResponseHelper;

    public IssueListResource(IssueListService issueListService, UserFactory userFactory, InternalServiceDeskService serviceDeskService, ErrorResultHelper errorHelper, RestResponseHelper restResponseHelper) {
        this.issueListService = issueListService;
        this.userFactory = userFactory;
        this.serviceDeskService = serviceDeskService;
        this.errorHelper = errorHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response getIssueList(@PathParam(value="projectKey") String projectKey, @QueryParam(value="jql") String jql, @QueryParam(value="columnNames") List<String> columns, @QueryParam(value="startIndex") int startIndex, @QueryParam(value="issuesPerPage") int issuesPerPage) {
        io.atlassian.fugue.Option optUser = StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption());
        if (optUser.isEmpty()) {
            return this.restResponseHelper.anErrorToResponse(this.anonymousUserError());
        }
        CheckedUser user = (CheckedUser)optUser.get();
        Either projectResult = this.serviceDeskService.getServiceDeskForKey(user, projectKey, false);
        if (projectResult.isLeft()) {
            return this.restResponseHelper.anErrorToResponse(this.invalidProjectError());
        }
        ServiceDesk serviceDesk = (ServiceDesk)projectResult.right().get();
        Either<AnError, ServiceDeskIssueList> issueListResult = this.issueListService.getIssueList(user, serviceDesk, jql, columns, startIndex, issuesPerPage);
        if (issueListResult.isLeft()) {
            return this.restResponseHelper.anErrorToResponse((AnError)issueListResult.left().get());
        }
        ServiceDeskIssueList issueList = (ServiceDeskIssueList)issueListResult.right().get();
        return this.restResponseHelper.ok((Object)this.buildIssueListResponse(user, issueList));
    }

    @GET
    @Path(value="/updated")
    public Response getIssueListIfUpdated(@PathParam(value="projectKey") String projectKey, @QueryParam(value="jql") String jql, @QueryParam(value="columnNames") List<String> columns, @QueryParam(value="startIndex") int startIndex, @QueryParam(value="issuesPerPage") int issuesPerPage, @QueryParam(value="currentIssueHash") String currentIssueHash) {
        io.atlassian.fugue.Option optUser = StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption());
        if (optUser.isEmpty()) {
            return this.restResponseHelper.anErrorToResponse(this.anonymousUserError());
        }
        CheckedUser user = (CheckedUser)optUser.get();
        Either projectResult = this.serviceDeskService.getServiceDeskForKey(user, projectKey, false);
        if (projectResult.isLeft()) {
            return this.restResponseHelper.anErrorToResponse(this.invalidProjectError());
        }
        ServiceDesk serviceDesk = (ServiceDesk)projectResult.right().get();
        Either<AnError, io.atlassian.fugue.Option<ServiceDeskIssueList>> issueListResult = this.issueListService.getIssueListIfUpdated(user, serviceDesk, jql, columns, startIndex, issuesPerPage, currentIssueHash);
        if (issueListResult.isLeft()) {
            return this.restResponseHelper.anErrorToResponse((AnError)issueListResult.left().get());
        }
        io.atlassian.fugue.Option issueListOpt = (io.atlassian.fugue.Option)issueListResult.right().get();
        if (issueListOpt.isEmpty()) {
            return Response.notModified().build();
        }
        ServiceDeskIssueList issueList = (ServiceDeskIssueList)issueListOpt.get();
        return this.restResponseHelper.ok((Object)this.buildIssueListResponse(user, issueList));
    }

    private IssueListResponse buildIssueListResponse(CheckedUser user, ServiceDeskIssueList issueList) {
        ServiceDeskIssueListView issueListView = this.issueListService.getIssueListView(user, issueList);
        return new IssueListResponse(issueList.getIssues().size(), issueList.getTotal(), issueList.getStart(), issueList.getEnd(), issueList.getIssueHash(), this.buildIssueRowResponses(issueListView.getIssueViews()), this.buildIssueColumnResponses(issueListView.getColumnViews()));
    }

    private List<IssueRowResponse> buildIssueRowResponses(List<IssueListIssueView> issueViewList) {
        return Lists.transform(issueViewList, issueView -> new IssueRowResponse(issueView.getKey(), issueView.getPosition(), this.buildIssueFieldResponses(issueView.getFields())));
    }

    private List<IssueFieldResponse> buildIssueFieldResponses(List<IssueListFieldView> issueFieldViewList) {
        return Lists.transform(issueFieldViewList, fieldView -> new IssueFieldResponse(fieldView.getFieldHtml(), fieldView.getFieldCssClass()));
    }

    private List<IssueColumnResponse> buildIssueColumnResponses(List<IssueListColumnView> columnViews) {
        return Lists.transform(columnViews, field -> new IssueColumnResponse(field.getFieldId(), field.getHeaderText()));
    }

    private AnError anonymousUserError() {
        return this.errorHelper.unauthorized401("sd.issue.search.anonymous", new Object[0]).build();
    }

    private AnError invalidProjectError() {
        return this.errorHelper.badRequest400("sd.issue.search.invalid.project", new Object[0]).build();
    }
}

