/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.organization;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.internal.feature.customer.search.CustomerSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UsersAndOrganizationsSearchService;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithOtherProjectCount;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganizationSettingService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.permission.restore.PermissionSchemeMisconfigurationService;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerResultsResponse;
import com.atlassian.servicedesk.internal.rest.organization.response.OrganisationPageResponse;
import com.atlassian.servicedesk.internal.rest.responses.CustomerOrganisationResponse;
import com.atlassian.servicedesk.internal.rest.util.UserAndOrgPaginationHelper;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class OrganisationPageDataProvider {
    private static final int ONE = 1;
    private final UsersAndOrganizationsSearchService usersAndOrganizationsSearchService;
    private final UserAndOrgPaginationHelper userAndOrgPaginationHelper;
    private final CustomerOrganizationSettingService organizationSettingService;
    private final ServiceDeskNotificationInternalSender serviceDeskNotificationInternalSender;
    private final PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final UserManager userManager;
    private final CustomerOrganizationService customerOrganizationService;
    private final FeatureManager featureManager;

    @Autowired
    public OrganisationPageDataProvider(UsersAndOrganizationsSearchService usersAndOrganizationsSearchService, UserAndOrgPaginationHelper userAndOrgPaginationHelper, CustomerOrganizationSettingService organizationSettingService, ServiceDeskNotificationInternalSender serviceDeskNotificationInternalSender, PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService, ServiceDeskPermissions serviceDeskPermissions, UserManager userManager, CustomerOrganizationService customerOrganizationService, FeatureManager featureManager) {
        this.usersAndOrganizationsSearchService = usersAndOrganizationsSearchService;
        this.userAndOrgPaginationHelper = userAndOrgPaginationHelper;
        this.organizationSettingService = organizationSettingService;
        this.serviceDeskNotificationInternalSender = serviceDeskNotificationInternalSender;
        this.permissionSchemeMisconfigurationService = permissionSchemeMisconfigurationService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.userManager = userManager;
        this.customerOrganizationService = customerOrganizationService;
        this.featureManager = featureManager;
    }

    public Either<AnError, OrganisationPageResponse> getOrganizationPageData(CheckedUser user, Project project, CustomerOrganization organization) {
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_LIST_PAGE_LAZY_SEARCH)) {
            return this.doActuallyGetLazyOrganizationData(user, project, organization);
        }
        int blockSize = this.userAndOrgPaginationHelper.getFetchBlockSize();
        int maxPages = this.userAndOrgPaginationHelper.getMaximumPagesToShow();
        return this.doActuallyGetOrganizationData(user, project, organization, blockSize, maxPages);
    }

    public Either<AnError, CustomerResultsResponse> searchOrganizationMembers(CheckedUser user, Project project, CustomerOrganization organization, String query, int pageNumber) {
        int blockSize = this.userAndOrgPaginationHelper.getFetchBlockSize();
        int maxPages = this.userAndOrgPaginationHelper.getMaximumPagesToShow();
        return this.doActuallySearchOrganizationMembers(user, project, query, organization, pageNumber, blockSize, maxPages);
    }

    private Either<AnError, OrganisationPageResponse> doActuallyGetLazyOrganizationData(CheckedUser user, Project project, CustomerOrganization organization) {
        OrganisationPageResponse organisationPageResponse = this.createBaseOrganisationPageResponse(true, user, project, organization);
        Either<AnError, Long> otherProjectCountForOrganization = this.getOtherProjectCountForOrganization(user, project, organization);
        if (otherProjectCountForOrganization.isLeft()) {
            return Either.left((Object)otherProjectCountForOrganization.left().get());
        }
        organisationPageResponse.setNumberOfOtherProjects((Long)otherProjectCountForOrganization.right().get());
        return Either.right((Object)organisationPageResponse);
    }

    private Either<AnError, OrganisationPageResponse> doActuallyGetOrganizationData(CheckedUser user, Project project, CustomerOrganization organization, int blockSize, int maxPages) {
        OrganisationPageResponse organisationPageResponse = this.createBaseOrganisationPageResponse(false, user, project, organization);
        Option<CustomerResultsResponse> invalidRequest = this.userAndOrgPaginationHelper.checkPageNumberRequest(user, 1, "", project, blockSize, maxPages);
        if (invalidRequest.isDefined()) {
            organisationPageResponse.setCustomerResults((CustomerResultsResponse)invalidRequest.get());
            return Either.right((Object)organisationPageResponse);
        }
        Either<AnError, Long> otherProjectCountForOrganization = this.getOtherProjectCountForOrganization(user, project, organization);
        if (otherProjectCountForOrganization.isLeft()) {
            return Either.left((Object)otherProjectCountForOrganization.left().get());
        }
        organisationPageResponse.setNumberOfOtherProjects((Long)otherProjectCountForOrganization.right().get());
        LimitedPagedRequest pagedRequest = this.userAndOrgPaginationHelper.createSearchPageRequest(1, blockSize, maxPages);
        Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> userLazyPagedResponse = this.performGetOrganizationMembers(user, pagedRequest, project, organization);
        return userLazyPagedResponse.map(result -> {
            organisationPageResponse.setCustomerResults(this.userAndOrgPaginationHelper.createCustomerResultsResponse(user, "", 1, project, (LazyPagedResponse<CustomerSearchItemResult>)result, blockSize, maxPages, (Option<String>)Option.none(), false));
            return organisationPageResponse;
        });
    }

    private Either<AnError, CustomerResultsResponse> doActuallySearchOrganizationMembers(CheckedUser user, Project project, String query, CustomerOrganization organization, int pageNumber, int blockSize, int maxPages) {
        Option<CustomerResultsResponse> invalidRequest = this.userAndOrgPaginationHelper.checkPageNumberRequest(user, pageNumber, query, project, blockSize, maxPages);
        if (invalidRequest.isDefined()) {
            return Either.right((Object)invalidRequest.get());
        }
        LimitedPagedRequest searchPageRequest = this.userAndOrgPaginationHelper.createSearchPageRequest(pageNumber, blockSize, maxPages);
        Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> lazyPagedResponseEither = query.trim().isEmpty() ? this.performGetOrganizationMembers(user, searchPageRequest, project, organization) : this.performSearchOrganizationMembers(user, query, searchPageRequest, project, organization);
        return lazyPagedResponseEither.map(searchResult -> this.userAndOrgPaginationHelper.createCustomerResultsResponse(user, query, pageNumber, project, (LazyPagedResponse<CustomerSearchItemResult>)searchResult, blockSize, maxPages, (Option<String>)Option.none(), false));
    }

    private Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> performGetOrganizationMembers(CheckedUser user, LimitedPagedRequest pagedRequest, Project project, CustomerOrganization organization) {
        return this.usersAndOrganizationsSearchService.searchForUsersInOrganization(user, project, organization, "", pagedRequest);
    }

    private Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> performSearchOrganizationMembers(CheckedUser user, String nameOrEmailQuery, LimitedPagedRequest pagedRequest, Project project, CustomerOrganization organization) {
        return this.usersAndOrganizationsSearchService.searchForUsersInOrganization(user, project, organization, nameOrEmailQuery, pagedRequest);
    }

    private Either<AnError, Long> getOtherProjectCountForOrganization(CheckedUser user, Project project, CustomerOrganization organization) {
        return this.customerOrganizationService.getOrganizationWithOtherProjectCount(user, project, organization).map(CustomerOrganizationWithOtherProjectCount::getOtherProjectCount);
    }

    private OrganisationPageResponse createBaseOrganisationPageResponse(boolean lazyResponse, CheckedUser user, Project project, CustomerOrganization organization) {
        OrganisationPageResponse pageResponse = lazyResponse ? OrganisationPageResponse.lazyOrganisationPageResponse(new CustomerOrganisationResponse(organization.getId(), organization.getName())) : OrganisationPageResponse.eagerOrganisationPageResponse(new CustomerOrganisationResponse(organization.getId(), organization.getName()));
        pageResponse.setCanManageOrganizations(this.organizationSettingService.canManageOrganizations(user));
        pageResponse.setCanDeleteOrganisations(this.organizationSettingService.canDeleteOrganizations(user));
        pageResponse.setOutgoingMailConfigured(this.serviceDeskNotificationInternalSender.isOutgoingMailConfigured());
        pageResponse.setCustomerRoleMisconfigured(this.permissionSchemeMisconfigurationService.isCustomerRoleCriticallyMisconfigured(project));
        pageResponse.setCanAdministerJIRA(this.serviceDeskPermissions.canAdministerJIRA((SDUser)user));
        pageResponse.setCanAdminister(this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project));
        pageResponse.setReadOnlyJIRA(!this.userManager.hasWritableDirectory());
        return pageResponse;
    }
}

