/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.organization;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganizationSettingService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/admin/organisation")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomerOrganisationSettingResource {
    private final UserFactory userFactory;
    private final CustomerOrganizationSettingService customerOrganizationSettingService;
    private final RestResponseHelper restResponseHelper;

    public CustomerOrganisationSettingResource(UserFactory userFactory, CustomerOrganizationSettingService customerOrganizationSettingService, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.customerOrganizationSettingService = customerOrganizationSettingService;
        this.restResponseHelper = restResponseHelper;
    }

    @PUT
    @Path(value="only-admin-manage")
    public Response enableOnlyAdminCanManageOrganisation() {
        return this.setOnlyAdminCanManageOrganisationEnabled(true);
    }

    @DELETE
    @Path(value="only-admin-manage")
    public Response disableOnlyAdminCanManageOrganisation() {
        return this.setOnlyAdminCanManageOrganisationEnabled(false);
    }

    private Response setOnlyAdminCanManageOrganisationEnabled(boolean isEnabled2) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.customerOrganizationSettingService.restrictToJiraAdmin((CheckedUser)user, isEnabled2)).yield((user, unit) -> unit);
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }
}

