/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.organization;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.search.organization.OrganisationSearchService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.atlassian.servicedesk.internal.feature.organization.UpdateOrganizationParams;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithMemberCount;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithOtherProjectCount;
import com.atlassian.servicedesk.internal.rest.organization.request.UpdateOrganisationRequest;
import com.atlassian.servicedesk.internal.rest.organization.response.OrganisationWithMemberCountResponse;
import com.atlassian.servicedesk.internal.rest.organization.response.OrganisationWithOtherProjectCountResponse;
import com.atlassian.servicedesk.internal.rest.responses.CustomerOrganisationResponse;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="organisations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomerOrganisationResource {
    private final CustomerOrganizationService organisationService;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final OrganisationSearchService organisationSearchService;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final int DEFAULT_LIMIT = 10;

    @Autowired
    public CustomerOrganisationResource(CustomerOrganizationService organisationService, RestResponseHelper restResponseHelper, UserFactory userFactory, OrganisationSearchService organisationSearchService, ServiceDeskProjectService serviceDeskProjectService) {
        this.organisationService = organisationService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.organisationSearchService = organisationSearchService;
        this.serviceDeskProjectService = serviceDeskProjectService;
    }

    @DELETE
    @Path(value="{orgId}")
    public Response deleteOrganisation(@PathParam(value="orgId") int orgId) {
        return this.doDeleteOrganisation(orgId);
    }

    @GET
    @Path(value="search")
    public Response searchForOrganisationsWithMemberCount(@QueryParam(value="query") String queryString) {
        return this.doSearchForOrganisationsWithMemberCount(queryString);
    }

    @PUT
    @Path(value="{orgId}/update")
    public Response updateOrganisation(@PathParam(value="orgId") int orgId, UpdateOrganisationRequest updateOrganisationRequest) {
        return this.doUpdateOrganisation(orgId, updateOrganisationRequest);
    }

    @GET
    @Path(value="project/{projectId}/invite/search")
    public Response searchForOrganisationsWithOtherProjectCount(@QueryParam(value="query") String queryString, @PathParam(value="projectId") long projectId) {
        return this.doSearchForOrganisationsWithOtherProjectCount(queryString, projectId);
    }

    @GET
    @Path(value="project/{projectId}/search")
    public Response searchWithinProject(@QueryParam(value="query") String queryString, @PathParam(value="projectId") long projectId) {
        return this.doSearchWithinProject(queryString, projectId);
    }

    private Response doDeleteOrganisation(int orgId) {
        return this.restResponseHelper.anErrorEitherToNoContentResponse(Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.organisationService.getOrganization((CheckedUser)user, orgId)).then((user, organisation) -> this.organisationService.deleteOrganization((CheckedUser)user, (CustomerOrganization)organisation)).yield((user, organisation, result) -> result));
    }

    private Response doSearchForOrganisationsWithMemberCount(String queryString) {
        return this.restResponseHelper.anErrorEitherToOkResponse(Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.organisationSearchService.searchForOrganisationsWithMemberCount((CheckedUser)user, queryString, 10)).yield((user, result) -> this.transformToResponse((Collection<CustomerOrganizationWithMemberCount>)result)));
    }

    private Response doSearchForOrganisationsWithOtherProjectCount(String queryString, long projectIdToExcludeFromCount) {
        return this.restResponseHelper.anErrorEitherToOkResponse(Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, projectIdToExcludeFromCount)).then((user, projectToExcludeFromCount) -> this.organisationSearchService.searchForOrganisationsWithOtherProjectCount((CheckedUser)user, (Project)projectToExcludeFromCount, queryString, 10)).yield((user, projectToExcludeFromCount, result) -> this.transformToOrganisationWithProjectCountResponse((Collection<CustomerOrganizationWithOtherProjectCount>)result)));
    }

    private Response doSearchWithinProject(String queryString, long projectId) {
        return this.restResponseHelper.anErrorEitherToOkResponse(Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, projectId)).then((user, project) -> this.organisationSearchService.searchForOrganisations((CheckedUser)user, (Project)project, queryString, 10)).yield((user, project, searchResult) -> this.transformToSearchResponse((Collection<CustomerOrganization>)searchResult)));
    }

    private Collection<CustomerOrganisationResponse> transformToSearchResponse(Collection<CustomerOrganization> organisations) {
        return organisations.stream().map(org -> new CustomerOrganisationResponse(org.getId(), org.getName())).collect(Collectors.toList());
    }

    private Collection<OrganisationWithMemberCountResponse> transformToResponse(Collection<CustomerOrganizationWithMemberCount> organisationWithMemberCounts) {
        return organisationWithMemberCounts.stream().map(OrganisationWithMemberCountResponse::new).collect(Collectors.toList());
    }

    private Collection<OrganisationWithOtherProjectCountResponse> transformToOrganisationWithProjectCountResponse(Collection<CustomerOrganizationWithOtherProjectCount> organisationWithProjectCounts) {
        return organisationWithProjectCounts.stream().map(OrganisationWithOtherProjectCountResponse::new).collect(Collectors.toList());
    }

    private Response doUpdateOrganisation(int orgId, UpdateOrganisationRequest updateOrganisationRequest) {
        io.atlassian.fugue.Either updateResult = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.organisationService.getOrganization((CheckedUser)user, orgId)).then((user, organisation) -> this.organisationService.updateOrganization((CheckedUser)user, (CustomerOrganization)organisation, this.toUpdateOrganisationParams(updateOrganisationRequest))).yield((user, organisation, updatedOrg) -> new CustomerOrganisationResponse((CustomerOrganization)updatedOrg));
        return this.restResponseHelper.anErrorEitherToOkResponse(updateResult);
    }

    private UpdateOrganizationParams toUpdateOrganisationParams(UpdateOrganisationRequest request) {
        return new UpdateOrganizationParams(request.getNewName());
    }
}

