/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.organization;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.organization.OrganisationPageDataProvider;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="project/{projectId}/organisation/{orgId}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomerOrganisationPageResource {
    private final CustomerOrganizationService organisationService;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final OrganisationPageDataProvider organisationPageDataProvider;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;

    @Autowired
    public CustomerOrganisationPageResource(CustomerOrganizationService organisationService, RestResponseHelper restResponseHelper, UserFactory userFactory, OrganisationPageDataProvider organisationPageDataProvider, ServiceDeskProjectService serviceDeskProjectService, FeatureManager featureManager, CommonErrors commonErrors) {
        this.organisationService = organisationService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.organisationPageDataProvider = organisationPageDataProvider;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
    }

    @GET
    public Response getPageData(@PathParam(value="projectId") long projectId, @PathParam(value="orgId") int orgId) {
        return this.doGetPageData(projectId, orgId);
    }

    @GET
    @Path(value="search")
    public Response searchMembersOfOrganisation(@PathParam(value="projectId") long projectId, @PathParam(value="orgId") int orgId, @QueryParam(value="query") String queryString, @QueryParam(value="page") @DefaultValue(value="1") int pageNumber) {
        return this.doSearchMember(projectId, orgId, queryString, pageNumber);
    }

    private Response doGetPageData(long projectId, int orgId) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either organisationPageEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, projectId)).then((user, project) -> this.organisationService.getOrganization((CheckedUser)user, orgId)).then(this.organisationPageDataProvider::getOrganizationPageData).yield((user, project, org, result) -> result);
        return this.restResponseHelper.anErrorEitherToOkResponse(organisationPageEither);
    }

    private Response doSearchMember(long projectId, int orgId, String queryString, int pageNumber) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either membersEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, projectId)).then((user, project) -> this.organisationService.getOrganization((CheckedUser)user, orgId)).then((user, project, org) -> this.organisationPageDataProvider.searchOrganizationMembers((CheckedUser)user, (Project)project, (CustomerOrganization)org, queryString, pageNumber)).yield((user, project, org, result) -> result);
        return this.restResponseHelper.anErrorEitherToOkResponse(membersEither);
    }
}

