/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.noeyeball.issueview;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.api.util.ServiceDeskApplicationVersionUtil;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.rest.issueview.responses.ServiceDeskIssueViewLoadedResponse;
import io.atlassian.fugue.Option;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="issueview/{issueKey}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ServiceDeskIssueViewResource {
    private final UserFactory userFactory;
    private final IssueManager issueManager;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil;
    private final RestResponseHelper restResponseHelper;

    protected ServiceDeskIssueViewResource(UserFactory userFactory, ServiceDeskInternalManager serviceDeskInternalManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, IssueManager issueManager, ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.issueManager = issueManager;
        this.serviceDeskApplicationVersionUtil = serviceDeskApplicationVersionUtil;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="opened")
    public Response issueLoaded(@PathParam(value="issueKey") String issueKey) {
        Option issueTypeName = Steps.begin((Option)StepsConverters.newerOption((com.atlassian.fugue.Option)this.userFactory.getCheckedUser().toOption())).then(user -> Option.option((Object)this.issueManager.getIssueObject(issueKey))).then(this::canViewServiceDeskIssue).then((user, issue, success) -> Option.option((Object)issue.getIssueType())).yield((user, issue, success, issueType) -> new ServiceDeskIssueViewLoadedResponse(issue.getId(), issue.getProjectId(), issueType.getName(), this.serviceDeskApplicationVersionUtil.getServiceDeskApplicationVersion()));
        return (Response)issueTypeName.fold(() -> Response.noContent().build(), arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0));
    }

    private Option<JSDSuccess> canViewServiceDeskIssue(CheckedUser user, Issue issue) {
        if (!this.serviceDeskInternalManager.isServiceDeskEnabled(issue.getProjectObject())) {
            return Option.none();
        }
        if (!this.serviceDeskLicenseAndPermissionService.canViewIssue((SDUser)user, issue)) {
            return Option.none();
        }
        return Option.some((Object)((Object)JSDSuccess.success()));
    }
}

