/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.kb;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseArticle;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.ConfluenceKBInternalSearchService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.rest.responses.kb.KnowledgeBaseArticleResponse;
import com.atlassian.servicedesk.internal.rest.responses.kb.KnowledgeBaseSearchResultResponse;
import com.atlassian.servicedesk.workinprogressapi.kb.KnowledgeBaseArticle;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/sharedportal")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SharedPortalConfluenceKnowledgeBaseResource {
    private final ConfluenceKBInternalSearchService confluenceKBInternalSearchService;
    private final InternalPortalService portalService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;

    public SharedPortalConfluenceKnowledgeBaseResource(ConfluenceKBInternalSearchService confluenceKBInternalSearchService, InternalPortalService portalService, UserFactory userFactory, RestResponseHelper restResponseHelper) {
        this.confluenceKBInternalSearchService = confluenceKBInternalSearchService;
        this.portalService = portalService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="/kb/articles")
    public Response getArticlesForSharedPortal(@QueryParam(value="query") String query) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.confluenceKBInternalSearchService.search((CheckedUser)user, query)).then((user, kbArticles) -> io.atlassian.fugue.Either.right(this.convertArticlesToResponses((CheckedUser)user, (List<KnowledgeBaseArticle>)kbArticles))).yield((user, kbArticles, kbArticleResponses) -> kbArticleResponses).map(KnowledgeBaseSearchResultResponse::new);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private List<KnowledgeBaseArticleResponse> convertArticlesToResponses(CheckedUser user, List<KnowledgeBaseArticle> kbArticles) {
        return kbArticles.stream().map(kbArticle -> this.convertArticleToResponse(user, (KnowledgeBaseArticle)kbArticle)).collect(Collectors.toList());
    }

    private KnowledgeBaseArticleResponse convertArticleToResponse(CheckedUser user, KnowledgeBaseArticle kbArticle) {
        if (kbArticle instanceof ConfluenceKnowledgeBaseArticle) {
            ConfluenceKnowledgeBaseArticle confluenceKbArticle = (ConfluenceKnowledgeBaseArticle)kbArticle;
            String portalName = (String)this.portalService.getFirstPortalByConfluenceSpaceKey(user, confluenceKbArticle.getSpaceKey()).toOption().map(Portal::getName).getOrElse((Object)"");
            return new KnowledgeBaseArticleResponse(confluenceKbArticle.getId(), confluenceKbArticle.getTitle(), confluenceKbArticle.getSummary(), confluenceKbArticle.getUrl(), portalName, confluenceKbArticle.getSpaceKey(), confluenceKbArticle.getApplicationId());
        }
        return new KnowledgeBaseArticleResponse(0L, kbArticle.getTitle(), kbArticle.getSummary(), kbArticle.getUrl());
    }
}

