/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.kb;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.rest.RestfulTableErrorResponse;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseInternalService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.internal.api.request.KBCreateSpaceRequest;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.rest.responses.kb.ConfluenceKBLinkResponse;
import com.atlassian.servicedesk.internal.applink.GenericAppLinkResponseHandlerFactory;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requests.kb.KBCreateDraftConfluenceRequest;
import com.atlassian.servicedesk.internal.rest.requests.kb.KBCreateDraftContext;
import com.atlassian.servicedesk.internal.rest.requests.kb.KBCreateDraftRequest;
import com.atlassian.servicedesk.internal.rest.requests.kb.KBEnableRequest;
import com.atlassian.servicedesk.internal.rest.requests.kb.KBLinkRequest;
import com.atlassian.servicedesk.internal.rest.responses.kb.KBCreateDraftDataResponse;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.JsonNode;

@Path(value="/servicedesk/{projectKey}/kb")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConfluenceKnowledgeBaseResource {
    private static final String CREATE_DRAFT_BLUEPRINT_PATH = "rest/create-dialog/1.0/content-blueprint/create-draft";
    private static final String LABELS_AUTOCOMPLETE_PATH = "labels/autocompletelabel.action";
    private static final String SPACE_KEY_QUERY_PARAM_NAME = "spaceKey";
    private static final String MAX_RESULT_QUERY_PARAM_NAME = "maxResults";
    private static final String CONTENT_ID_QUERY_PARAM_NAME = "contentId";
    private static final String QUERY_STRING_QUERY_PARAM_NAME = "query";
    private static final int MAX_RESULTS = 3;
    private static final int CONTENT_ID = 0;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private final ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService;
    private final IssueService issueService;
    private final VpOriginManager vpOriginManager;
    private final InternalPortalService portalService;
    private final RequestTypeInternalService rtService;
    private final ServiceDeskProjectService sdProjectService;
    private final InternalServiceDeskService sdService;
    private final InternalPortalService internalPortalService;
    private final ConfluenceKBErrors confluenceKBErrors;
    private final UserFactory userFactory;
    private final GenericAppLinkResponseHandlerFactory genericAppLinkResponseHandlerFactory;
    private final RestResponseHelper restResponseHelper;
    private final RichTextRenderer richTextRenderer;

    public ConfluenceKnowledgeBaseResource(ServiceDeskAppLinkService serviceDeskAppLinkService, ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService, ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService, IssueService issueService, VpOriginManager vpOriginManager, InternalPortalService portalService, RequestTypeInternalService rtService, ServiceDeskProjectService sdProjectService, InternalServiceDeskService sdService, InternalPortalService internalPortalService, ConfluenceKBErrors confluenceKBErrors, UserFactory userFactory, GenericAppLinkResponseHandlerFactory genericAppLinkResponseHandlerFactory, RestResponseHelper restResponseHelper, RichTextRenderer richTextRenderer) {
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.confluenceKnowledgeBaseInternalService = confluenceKnowledgeBaseInternalService;
        this.issueService = issueService;
        this.vpOriginManager = vpOriginManager;
        this.portalService = portalService;
        this.rtService = rtService;
        this.sdProjectService = sdProjectService;
        this.sdService = sdService;
        this.internalPortalService = internalPortalService;
        this.confluenceKBErrors = confluenceKBErrors;
        this.userFactory = userFactory;
        this.genericAppLinkResponseHandlerFactory = genericAppLinkResponseHandlerFactory;
        this.restResponseHelper = restResponseHelper;
        this.richTextRenderer = richTextRenderer;
    }

    @POST
    @Path(value="{applicationLinkId}/space/{spaceKey}")
    public Response updateKbLink(@PathParam(value="projectKey") String projectKey, @PathParam(value="applicationLinkId") String applicationLinkId, @PathParam(value="spaceKey") String spaceKey, KBLinkRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.updateKbLink((CheckedUser)user, (Project)project, applicationLinkId, spaceKey, request)).yield((user, project, kbLink) -> kbLink).map(ConfluenceKBLinkResponse::toConfluenceKBLinkResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="{applicationLinkId}/space")
    public Response getSpaces(@PathParam(value="projectKey") String projectKey, @PathParam(value="applicationLinkId") String applicationLinkId, @QueryParam(value="query") String query) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.confluenceKnowledgeBaseInternalService.getSpaceSearchRelativePath(Option.option((Object)query))).then((user, project, path) -> this.serviceDeskAppLinkService.makeGetRequest(user, project, applicationLinkId, path, (BaseAppLinkResponseHandler)this.genericAppLinkResponseHandlerFactory.createHandler())).yield((user, project, path, appLinkResponse) -> appLinkResponse.toString());
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    public Response getKBLink(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((arg_0, arg_1) -> ((ConfluenceKnowledgeBaseInternalService)this.confluenceKnowledgeBaseInternalService).getKBLink(arg_0, arg_1)).yield((user, project, kblink) -> kblink);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="requestenable/{id}")
    public Response getRequestType(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") Integer id) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.confluenceKnowledgeBaseInternalService.getSearchEnabled(project, user, id.intValue())).yield((user, project, KbEnableResponse) -> KbEnableResponse);
        return (Response)result.fold(this::anErrorToRestfulTableResponse, arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0));
    }

    @PUT
    @Path(value="requestenable/{id}")
    public Response updateRequestType(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") Integer id, KBEnableRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.confluenceKnowledgeBaseInternalService.updateSearchEnabled(project, user, id.intValue(), request.getEnabled(), request.getLabels())).yield((user, project, namedErrorsOrKbEnableResponse) -> namedErrorsOrKbEnableResponse);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), arg_0 -> ((RestResponseHelper)this.restResponseHelper).namedErrorsEitherToOkResponse(arg_0));
    }

    @POST
    @Path(value="requestenable")
    public Response createRequestType(@PathParam(value="projectKey") String projectKey, KBEnableRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> request.getRequestId().toRight(this.confluenceKBErrors::CONFLUENCE_REQUEST_NOT_FOUND)).then((user, requestId) -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, requestId, project) -> this.confluenceKnowledgeBaseInternalService.updateSearchEnabled(project, user, requestId.intValue(), request.getEnabled(), request.getLabels())).yield((user, requestId, project, namedErrorsOrKbEnableResponse) -> namedErrorsOrKbEnableResponse);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), arg_0 -> ((RestResponseHelper)this.restResponseHelper).namedErrorsEitherToOkResponse(arg_0));
    }

    @DELETE
    @Path(value="requestenable/{id}")
    public Response deleteRequestType(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") Integer id) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.confluenceKnowledgeBaseInternalService.deleteSearchEnabled(project, user, id.intValue())).yield((user, project, namedErrorsOrKbEnableResponse) -> namedErrorsOrKbEnableResponse);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), arg_0 -> ((RestResponseHelper)this.restResponseHelper).namedErrorsEitherToOkResponse(arg_0));
    }

    @GET
    @Path(value="requestenable")
    public Response getAllRequestType(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.portalService::getPortalByProject).then((user, project, portal) -> this.sdService.getServiceDeskForProject(user, project, false)).then((user, project, portal, serviceDesk) -> this.confluenceKnowledgeBaseInternalService.getAllSearchEnabled(user, serviceDesk, project, portal)).yield((user, project, portal, serviceDesk, validationErrorsOrKbEnableResponseList) -> validationErrorsOrKbEnableResponseList);
        return (Response)result.fold(this::anErrorToRestfulTableResponse, arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0));
    }

    @GET
    @Path(value="create-draft")
    public Response getKBDraftData(@QueryParam(value="issueId") Long issueId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getIssue((CheckedUser)user, (Option<Long>)Option.option((Object)issueId))).then((user, issue) -> Option.option((Object)issue.getProjectObject()).toRight(this.confluenceKBErrors::CONFLUENCE_PROJECT_NOT_FOUND)).yield((user, issue, project) -> {
            List<String> labels = this.getLabelList((CheckedUser)user, (Issue)issue);
            return new KBCreateDraftDataResponse(issue.getId(), project.getKey(), issue.getSummary(), labels);
        });
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="create-draft")
    public Response postKBDraft(KBCreateDraftRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getIssue((CheckedUser)user, request.getIssueId())).then((user, issue) -> Option.option((Object)issue.getProjectObject()).toRight(this.confluenceKBErrors::CONFLUENCE_PROJECT_NOT_FOUND)).then((user, issue, project) -> this.confluenceKnowledgeBaseInternalService.getKBLink(user, project)).then((user, issue, project, kbLink) -> this.postKBDraft((CheckedUser)user, (Project)project, (ConfluenceKnowledgeBaseLink)kbLink, (Issue)issue, request)).yield((user, issue, project, kbLink, jsonNode) -> jsonNode.toString());
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="create-space")
    public Response createSpace(@PathParam(value="projectKey") String projectKey, KBCreateSpaceRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.serviceDeskAppLinkService.getApplicationLink((String)request.getApplicationLinkId().getOrElse((Object)""))).then((user, project, appLink) -> this.confluenceKnowledgeBaseService.createSpace(user, project, appLink, request)).then((user, project, appLink, space) -> this.confluenceKnowledgeBaseInternalService.updateKBLink(user, project, appLink.getId().get(), appLink.getRpcUrl().toString(), appLink.getName(), space.getKey(), space.getName(), space.getUrl())).yield((user, project, appLink, space, kbLink) -> kbLink).map(ConfluenceKBLinkResponse::toConfluenceKBLinkResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="labels")
    public Response getLabels(@PathParam(value="projectKey") String projectKey, @QueryParam(value="query") String query) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.sdProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((arg_0, arg_1) -> ((ConfluenceKnowledgeBaseInternalService)this.confluenceKnowledgeBaseInternalService).getKBLink(arg_0, arg_1)).then((user, project, kbLink) -> this.serviceDeskAppLinkService.makeGetRequest(user, project, kbLink.getApplicationId(), this.getLabelsQueryPath(query, kbLink.getSpaceKey()), (BaseAppLinkResponseHandler)this.genericAppLinkResponseHandlerFactory.createHandler())).yield((user, project, kbLink, jsonNode) -> jsonNode.toString());
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private String getLabelsQueryPath(String query, String spaceKey) {
        String queryString = (String)Option.option((Object)query).getOrElse((Object)"");
        return UriBuilder.fromPath((String)LABELS_AUTOCOMPLETE_PATH).queryParam(SPACE_KEY_QUERY_PARAM_NAME, new Object[]{spaceKey}).queryParam(MAX_RESULT_QUERY_PARAM_NAME, new Object[]{3}).queryParam(CONTENT_ID_QUERY_PARAM_NAME, new Object[]{0}).queryParam(QUERY_STRING_QUERY_PARAM_NAME, new Object[]{queryString}).build(new Object[0]).toString();
    }

    private io.atlassian.fugue.Either<AnError, ConfluenceKnowledgeBaseLink> updateKbLink(CheckedUser user, Project project, String applicationLinkId, String spaceKey, KBLinkRequest request) {
        return this.confluenceKnowledgeBaseInternalService.updateKBLink(user, project, applicationLinkId, (String)request.getAppUrl().getOrElse((Object)""), (String)request.getAppName().getOrElse((Object)""), spaceKey, (String)request.getSpaceName().getOrElse((Object)""), (String)request.getSpaceUrl().getOrElse((Object)""));
    }

    private io.atlassian.fugue.Either<AnError, Issue> getIssue(CheckedUser user, Option<Long> issueId) {
        if (issueId.isEmpty()) {
            return io.atlassian.fugue.Either.left((Object)this.confluenceKBErrors.CONFLUENCE_REQUEST_NOT_FOUND());
        }
        Long id = (Long)issueId.get();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user.forJIRA(), id);
        if (issueResult.isValid()) {
            return io.atlassian.fugue.Either.right((Object)issueResult.getIssue());
        }
        return io.atlassian.fugue.Either.left((Object)this.confluenceKBErrors.CONFLUENCE_REQUEST_NOT_FOUND());
    }

    private List<String> getLabelList(CheckedUser user, Issue issue) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)Option.option((Object)this.vpOriginManager.lookup(issue)).toRight(this.confluenceKBErrors::CONFLUENCE_REQUEST_TYPE_NOT_FOUND)).then(vpOrigin -> this.portalService.getPortal(user, vpOrigin.getPortalKey())).then((vpOrigin, portal) -> this.sdProjectService.getProjectById(user, this.internalPortalService.getProjectIdForPortal((Portal)portal))).then((vpOrigin, portal, project) -> this.rtService.getRequestTypeByKey(user, vpOrigin.getRequestTypeKey(), project, (Portal)portal)).then((vpOrigin, portal, project, requestType) -> this.confluenceKnowledgeBaseInternalService.getAllLabelsForRequestType(requestType)).yield((vpOrigin, portal, project, requestType, labels) -> labels);
        return (List)result.getOr(() -> Collections.emptyList());
    }

    private io.atlassian.fugue.Either<AnError, JsonNode> postKBDraft(CheckedUser user, Project project, ConfluenceKnowledgeBaseLink kbLink, Issue issue, KBCreateDraftRequest request) {
        String descriptionHtml = this.richTextRenderer.renderWiki(issue.getDescription(), new RenderOption[0]);
        KBCreateDraftConfluenceRequest confluenceRequest = new KBCreateDraftConfluenceRequest(kbLink.getSpaceKey(), (String)request.getTemplate().getOrElse((Object)""), (String)request.getTitle().getOrElse((Object)""), new KBCreateDraftContext(kbLink.getSpaceKey(), descriptionHtml, (String)request.getLabels().getOrElse((Object)""), issue.getKey(), kbLink.getApplicationId()));
        return this.serviceDeskAppLinkService.makePostRequest(user, project, kbLink.getApplicationId(), CREATE_DRAFT_BLUEPRINT_PATH, (Object)confluenceRequest, (BaseAppLinkResponseHandler)this.genericAppLinkResponseHandlerFactory.createHandler());
    }

    private Response anErrorToRestfulTableResponse(AnError error) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("requestName", error.getMessage().getMessage());
        String reasonKey2 = (String)error.getErrorCode().map(ErrorCode::getErrorCode).getOrElse((Object)"");
        RestfulTableErrorResponse errorResponse = new RestfulTableErrorResponse(reasonKey2, errorMap);
        return Response.status((int)error.getHttpStatusCode()).entity((Object)errorResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

