/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.kb;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBPermissionService;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.responses.ConfluenceKBViewResponse;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="knowledgebase/permissions/{projectKey}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConfluenceKBPermissionResource {
    private Logger logger = LoggerFactory.getLogger(ConfluenceKBPermissionResource.class);
    private final ConfluenceKBPermissionService permissionService;
    private final ServiceDeskProjectService projectService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;

    public ConfluenceKBPermissionResource(ConfluenceKBPermissionService permissionService, ServiceDeskProjectService projectService, UserFactory userFactory, RestResponseHelper restResponseHelper) {
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response checkAndFixViewStatus(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.projectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.permissionService::getConfluenceViewStatus).yield(this::validateAndFixPermissions);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/anonymous")
    public Response checkAnonymousView(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.projectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.permissionService::getConfluenceViewStatus).yield((user, project, permission) -> permission.isAnonymousViewEnabled());
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/unlicensed")
    public Response checkUnlicensedAuthenticatedView(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.projectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.permissionService::getConfluenceViewStatus).yield((user, project, permission) -> permission.isUnlicensedViewPermissionEnabled());
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="/unlicensed/enable")
    public Response enableUnlicensedAuthenticatedView(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.projectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.permissionService::enableUnlicensedAuthenticatedView).yield((user, project, permission) -> permission);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="/unlicensed/disable")
    public Response disableUnlicensedAuthenticatedView(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.projectService.getProjectByKey((CheckedUser)user, projectKey)).then(this.permissionService::disableUnlicensedAuthenticatedView).yield((user, project, permission) -> permission);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private ConfluenceKBViewResponse validateAndFixPermissions(CheckedUser user, Project project, ConfluenceKBViewResponse permission) {
        io.atlassian.fugue.Either<AnError, ConfluenceKBViewResponse> validatedPermissionEither = this.permissionService.validateAndFixConfluenceViewStatus(user, project, permission);
        if (validatedPermissionEither.isLeft()) {
            this.logger.warn("Attempting to enable Confluence unlicensed permission for {} failed", (Object)permission.getSpaceKey());
        }
        return (ConfluenceKBViewResponse)validatedPermissionEither.fold(error -> permission, validatedPermission -> validatedPermission);
    }
}

