/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.feedback.response;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReport;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class FeedbackReportResponse {
    private String agentName = "";
    private String agentDisplayName = "";
    private String agentAvatar;
    private Boolean agentNotActive = true;
    private String requestTypeName;
    private Long requestTypeIcon;
    private Integer rating;
    private String comment;
    private String feedbackDate;
    private String issueKey;
    private String issueUrl;

    public FeedbackReportResponse(FeedbackReport report) {
        if (report.getAgent().isDefined()) {
            ApplicationUser agent = (ApplicationUser)report.getAgent().get();
            this.agentName = agent.getName();
            this.agentDisplayName = agent.getDisplayName();
            this.agentNotActive = !agent.isActive();
        }
        if (report.getRequestType().isDefined()) {
            RequestType requestType = (RequestType)report.getRequestType().get();
            this.requestTypeName = requestType.getName();
            this.requestTypeIcon = requestType.getIconId();
        }
        this.rating = (Integer)report.getRating().getOrNull();
        this.comment = (String)report.getComment().getOrElse((Object)"");
        this.issueKey = report.getIssueKey();
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentDisplayName() {
        return this.agentDisplayName;
    }

    public String getAgentAvatar() {
        return this.agentAvatar;
    }

    public Boolean getAgentNotActive() {
        return this.agentNotActive;
    }

    public String getRequestTypeName() {
        return this.requestTypeName;
    }

    public Long getRequestTypeIcon() {
        return this.requestTypeIcon;
    }

    public Integer getRating() {
        return this.rating;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFeedbackDate() {
        return this.feedbackDate;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getIssueUrl() {
        return this.issueUrl;
    }

    public void setFeedbackDate(String feedbackDate) {
        this.feedbackDate = feedbackDate;
    }

    public void setIssueUrl(String issueUrl) {
        this.issueUrl = issueUrl;
    }

    public void setAgentAvatar(String agentAvatar) {
        this.agentAvatar = agentAvatar;
    }
}

