/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.feedback;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.feedbackevents.FeedbackAnalyticEvent;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackErrors;
import com.atlassian.servicedesk.internal.feature.feedback.settings.FeedbackSettingsService;
import com.atlassian.servicedesk.internal.rest.feedback.response.QuestionErrorResponse;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="{projectKey}/settings/feedback")
public class FeedbackSettingsResource {
    private final FeedbackSettingsService feedbackSettingsService;
    private final InternalServiceDeskService serviceDeskService;
    private final AnalyticsService analyticsService;
    private final FeedbackErrors feedbackErrors;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;
    private final ErrorTranslationHelper errorTranslationHelper;

    protected FeedbackSettingsResource(InternalServiceDeskService serviceDeskService, FeedbackSettingsService feedbackSettingsService, AnalyticsService analyticsService, FeedbackErrors feedbackErrors, UserFactory userFactory, RestResponseHelper restResponseHelper, ErrorTranslationHelper errorTranslationHelper) {
        this.serviceDeskService = serviceDeskService;
        this.feedbackSettingsService = feedbackSettingsService;
        this.analyticsService = analyticsService;
        this.feedbackErrors = feedbackErrors;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
        this.errorTranslationHelper = errorTranslationHelper;
    }

    @GET
    public Response getFeedbackSettings(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false)).then((checkedUser, serviceDesk) -> this.feedbackSettingsService.getFeedbackSettings(checkedUser.forJIRA(), (ServiceDesk)serviceDesk)).yield((checkedUser, serviceDesk, feedbackSettings) -> feedbackSettings);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="enable")
    public Response turnOnFeedbackFeature(@PathParam(value="projectKey") String projectKey) {
        return this.setFeedbackFeature(projectKey, true);
    }

    @DELETE
    @Path(value="enable")
    public Response turnOffFeedbackFeature(@PathParam(value="projectKey") String projectKey) {
        return this.setFeedbackFeature(projectKey, false);
    }

    @PUT
    @Path(value="question")
    public Response setFeedbackQuestion(@PathParam(value="projectKey") String projectKey, String jsQuestion) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false)).then((checkedUser, serviceDesk) -> this.mapJsonStringToString(jsQuestion)).then((checkedUser, serviceDesk, question) -> this.feedbackSettingsService.setFeedbackQuestion(checkedUser.forJIRA(), (ServiceDesk)serviceDesk, (String)question)).yield((checkedUser, serviceDesk, question, currentQuestion) -> {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.question.changed", Long.valueOf(serviceDesk.getProjectId())));
            return Unit.Unit();
        });
        return (Response)result.fold(error -> this.inlineEditErrorResponse((SDUser)this.userFactory.getUncheckedUser(), (AnError)error), unit -> this.restResponseHelper.noContent());
    }

    private io.atlassian.fugue.Either<AnError, String> mapJsonStringToString(String jsQuestion) {
        return Option.option((Object)StringUtils.stripToNull((String)jsQuestion)).map(s -> StringUtils.strip((String)s, (String)"\"")).filter(StringUtils::isNotBlank).toRight(this.feedbackErrors::INVALID_QUESTION_BLANK);
    }

    private Response setFeedbackFeature(String projectKey, boolean isEnabled2) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false)).then((checkedUser, serviceDesk) -> this.feedbackSettingsService.setFeedbackFeatureEnabled(checkedUser.forJIRA(), (ServiceDesk)serviceDesk, isEnabled2)).yield((checkedUser, serviceDesk, currentStatus) -> currentStatus);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private Response inlineEditErrorResponse(SDUser user, AnError anError) {
        ErrorMessage message = anError.getMessage();
        QuestionErrorResponse questionErrorResponse = new QuestionErrorResponse(this.getTranslatedError(user.i18NHelper(), message));
        return Response.status((int)anError.getHttpStatusCode()).entity((Object)questionErrorResponse).build();
    }

    private String getTranslatedError(I18nHelper i18nHelper, ErrorMessage message) {
        return this.errorTranslationHelper.translateErrorMessage(message, i18nHelper);
    }
}

