/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.feedback;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.SimplePagedRequest;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.feedbackevents.FeedbackAnalyticEvent;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportQuery;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportQueryBuilderFactory;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportRequest;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.report.ReportTimescale;
import com.atlassian.servicedesk.internal.api.report.ReportTimescaleManager;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.user.ServiceDeskUserTimeZoneService;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackErrors;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportInternalService;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportResult;
import com.atlassian.servicedesk.internal.rest.feedback.FeedbackReportDataProvider;
import com.atlassian.servicedesk.internal.util.JsonSerializer;
import io.atlassian.fugue.Option;
import java.util.TimeZone;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jsoup.helper.StringUtil;

@Path(value="projects/{projectKey}/report/feedback")
public class FeedbackReportResource {
    private final FeedbackReportInternalService feedbackReportInternalService;
    private final UserFactory sdUserFactory;
    private final FeedbackReportDataProvider feedbackReportDataProvider;
    private final JsonSerializer<FeedbackReportRequest> jsonSerializer;
    private final InternalServiceDeskProjectManager serviceDeskProjectManager;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ServiceDeskUserTimeZoneService userTimeZoneService;
    private final AnalyticsService analyticsService;
    private final FeedbackErrors feedbackErrors;
    private final FeedbackReportQueryBuilderFactory feedbackReportQueryBuilderFactory;
    private final ReportTimescaleManager reportTimescaleManager;
    private final RestResponseHelper restResponseHelper;

    public FeedbackReportResource(FeedbackReportInternalService feedbackReportInternalService, UserFactory sdUserFactory, FeedbackReportDataProvider feedbackReportDataProvider, InternalServiceDeskProjectManager serviceDeskProjectManager, InternalServiceDeskService internalServiceDeskService, ServiceDeskUserTimeZoneService userTimeZoneService, AnalyticsService analyticsService, FeedbackErrors feedbackErrors, FeedbackReportQueryBuilderFactory feedbackReportQueryBuilderFactory, ReportTimescaleManager reportTimescaleManager, RestResponseHelper restResponseHelper) {
        this.feedbackReportInternalService = feedbackReportInternalService;
        this.sdUserFactory = sdUserFactory;
        this.reportTimescaleManager = reportTimescaleManager;
        this.feedbackReportDataProvider = feedbackReportDataProvider;
        this.serviceDeskProjectManager = serviceDeskProjectManager;
        this.internalServiceDeskService = internalServiceDeskService;
        this.feedbackErrors = feedbackErrors;
        this.feedbackReportQueryBuilderFactory = feedbackReportQueryBuilderFactory;
        this.jsonSerializer = new JsonSerializer<FeedbackReportRequest>(FeedbackReportRequest.class);
        this.userTimeZoneService = userTimeZoneService;
        this.analyticsService = analyticsService;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getFeedbackData(@PathParam(value="projectKey") String projectKey, @QueryParam(value="jsonFilter") String jsonCriteria, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="expand") String expand) {
        io.atlassian.fugue.Either reportResultEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.sdUserFactory.getCheckedUser())).then(checkedUser -> this.serviceDeskProjectManager.getProjectByKey(projectKey)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, serviceDesk) -> this.toFeedbackReportQuery((CheckedUser)checkedUser, jsonCriteria, start, limit, (ServiceDesk)serviceDesk)).then((checkedUser, project, serviceDesk, feedbackReportQuery) -> this.feedbackReportInternalService.getFeedbackReport((CheckedUser)checkedUser, (FeedbackReportQuery)feedbackReportQuery, expand, (ServiceDesk)serviceDesk)).yield((checkedUser, project, serviceDesk, feedbackReportQuery, feedbackReportResult) -> {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.report.viewed", project.getId()));
            return this.feedbackReportDataProvider.buildFeedbackReportResource((FeedbackReportResult)feedbackReportResult);
        });
        return this.restResponseHelper.anErrorEitherToOkResponse(reportResultEither);
    }

    private io.atlassian.fugue.Either<AnError, FeedbackReportQuery> toFeedbackReportQuery(CheckedUser checkedUser, String jsonCriteria, int start, int limit, ServiceDesk serviceDesk) {
        return Steps.begin(this.toFeedbackReportRequest(jsonCriteria)).then(feedbackReportRequest -> this.buildQueryBasedOnRequest(checkedUser, (FeedbackReportRequest)feedbackReportRequest, serviceDesk, start, limit)).yield((feedbackReportRequest, feedbackReportQuery) -> feedbackReportQuery);
    }

    private io.atlassian.fugue.Either<AnError, FeedbackReportQuery> buildQueryBasedOnRequest(CheckedUser checkedUser, FeedbackReportRequest reportRequest, ServiceDesk serviceDesk, int start, int limit) {
        TimeZone timezone = this.userTimeZoneService.getUserTimeZone(checkedUser);
        ReportTimescale timescale = this.getTimescale(reportRequest.getTimescaleId());
        DateTimeZone userTimezone = DateTimeZone.forTimeZone((TimeZone)timezone);
        DateTime endDate = DateTime.now((DateTimeZone)userTimezone);
        DateTime startDate = this.reportTimescaleManager.getTimeScaleStartDate(endDate, timescale);
        if (timescale != this.reportTimescaleManager.getDefaultTimescale()) {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.date.range.changed", Long.valueOf(serviceDesk.getProjectId())));
        }
        return io.atlassian.fugue.Either.right((Object)this.feedbackReportQueryBuilderFactory.createBuilder().feedbackReportRequest(reportRequest, serviceDesk).startDate(startDate.toDate()).endDate(endDate.toDate()).pageRequest(this.fromQueryParams(start, limit)).build());
    }

    private io.atlassian.fugue.Either<AnError, FeedbackReportRequest> toFeedbackReportRequest(String jsonCriteria) {
        if (StringUtil.isBlank((String)jsonCriteria)) {
            return io.atlassian.fugue.Either.right((Object)new FeedbackReportRequest());
        }
        return (io.atlassian.fugue.Either)Option.option((Object)this.jsonSerializer.deserialize(jsonCriteria)).fold(() -> io.atlassian.fugue.Either.left((Object)this.feedbackErrors.INVALID_FEEDBACK_REPORT_CRITERIA()), io.atlassian.fugue.Either::right);
    }

    private PagedRequest fromQueryParams(Integer start, Integer limit) {
        return SimplePagedRequest.paged((int)((Integer)Option.option((Object)start).getOrElse((Object)0)), (int)((Integer)Option.option((Object)limit).getOrElse((Object)50)));
    }

    private ReportTimescale getTimescale(Integer timescaleId) {
        return (ReportTimescale)Option.option((Object)timescaleId).map(id -> this.reportTimescaleManager.getTimescale(id.longValue())).getOrElse((Object)this.reportTimescaleManager.getDefaultTimescale());
    }
}

