/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.emailchannel;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelService;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingService;
import com.atlassian.servicedesk.internal.feature.emailchannel.healer.EmailChannelVerificationService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectServiceScala;
import com.atlassian.servicedesk.internal.rest.emailchannel.request.GlobalEmailTestRequest;
import com.atlassian.servicedesk.internal.rest.emailchannel.response.EmailSettingsTestResponseHelper;
import com.atlassian.servicedesk.squalor.email.SDMailServerConnectionTestSuccess;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/admin/email")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GlobalEmailChannelResource {
    private final UserFactory userFactory;
    private final EmailChannelService emailChannelService;
    private final ServiceDeskProjectServiceScala serviceDeskProjectServiceScala;
    private final ErrorResultHelper errorResultHelper;
    private final EmailSettingsTestResponseHelper emailSettingsTestResponseHelper;
    private final RestResponseHelper restResponseHelper;
    private final EmailChannelVerificationService emailChannelVerificationService;
    private final EmailChannelSettingService emailChannelSettingService;

    public GlobalEmailChannelResource(UserFactory userFactory, EmailChannelService emailChannelService, ServiceDeskProjectServiceScala serviceDeskProjectServiceScala, ErrorResultHelper errorResultHelper, EmailSettingsTestResponseHelper emailSettingsTestResponseHelper, RestResponseHelper restResponseHelper, EmailChannelVerificationService emailChannelVerificationService, EmailChannelSettingService emailChannelSettingService) {
        this.userFactory = userFactory;
        this.emailChannelService = emailChannelService;
        this.serviceDeskProjectServiceScala = serviceDeskProjectServiceScala;
        this.errorResultHelper = errorResultHelper;
        this.emailSettingsTestResponseHelper = emailSettingsTestResponseHelper;
        this.restResponseHelper = restResponseHelper;
        this.emailChannelVerificationService = emailChannelVerificationService;
        this.emailChannelSettingService = emailChannelSettingService;
    }

    @POST
    @Path(value="test")
    public Response testEmailServer(GlobalEmailTestRequest globalEmailTestRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getProject((CheckedUser)user, globalEmailTestRequest.getProjectId())).then((user, project) -> this.getEmailChannel((CheckedUser)user, globalEmailTestRequest.getEmailSettingsId())).yield(this::testEmailChannel);
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    @DELETE
    @Path(value="delete")
    public Response deleteEmailSettingsDBObject(@QueryParam(value="projectId") Long projectId, @QueryParam(value="emailSettingsId") Integer emailSettingsId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.emailChannelSettingService.removeEmailChannelAsJiraAdmin((CheckedUser)user, emailSettingsId)).yield((user, removalResult) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, Project> getProject(CheckedUser user, Option<Long> projectIdOpt) {
        return projectIdOpt.toRight(() -> this.projectIdMissingError(user)).flatMap(projectId -> this.serviceDeskProjectServiceScala.getProjectByIdAsJiraAdmin(user, (long)projectId));
    }

    private io.atlassian.fugue.Either<AnError, EmailChannelScala> getEmailChannel(CheckedUser user, Option<Integer> emailSettingsIdOpt) {
        return emailSettingsIdOpt.toRight(() -> this.emailSettingsIdMissingError(user)).flatMap(emailSettingsId -> this.emailChannelService.getEmailChannelByIdAsJiraAdmin(user, emailSettingsId.longValue()));
    }

    private Response testEmailChannel(CheckedUser user, Project project, EmailChannelScala emailChannel) {
        return (Response)this.emailChannelVerificationService.testEmailChannel(user, project, emailChannel).fold(errorList -> this.restResponseHelper.ok((Object)this.emailSettingsTestResponseHelper.buildFailureResponse((List<AnError>)errorList)), success -> this.restResponseHelper.ok((Object)this.emailSettingsTestResponseHelper.buildSuccessResponse(user, (SDMailServerConnectionTestSuccess)success)));
    }

    private AnError projectIdMissingError(CheckedUser user) {
        return this.errorResultHelper.badRequest400("sd.admin.email.settings.project.id.missing.error", new Object[0]).user(user.forJIRA()).build();
    }

    private AnError emailSettingsIdMissingError(CheckedUser user) {
        return this.errorResultHelper.badRequest400("sd.admin.email.settings.email.settings.id.missing.error", new Object[0]).user(user.forJIRA()).build();
    }
}

