/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.emailchannel;

import com.atlassian.fugue.Option;
import com.atlassian.jira.mail.processor.api.channel.ChannelDefinition;
import com.atlassian.jira.mail.processor.api.channel.ChannelKey;
import com.atlassian.jira.mail.processor.api.channel.ChannelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldValidator;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalService;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.ServiceDeskSignupValidator;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelHelper;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelService;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.rest.responses.emailsettings.EmailSettingDialogResponse;
import com.atlassian.servicedesk.internal.rest.responses.emailsettings.EmailSettingPageResponse;
import com.atlassian.servicedesk.internal.rest.responses.emailsettings.EmailSettingResponse;
import com.atlassian.servicedesk.internal.rest.responses.emailsettings.IncomingEmailRequestTypeResponse;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailSettingsPageDataProvider {
    private static final String HIDDEN = "hidden";
    private final RequestTypeInternalService requestTypeInternalService;
    private final EmailChannelService emailSettingsService;
    private final ServiceDeskNotificationInternalSender serviceDeskNotificationSender;
    private final RequestTypeFieldInternalService requestTypeFieldService;
    private final RequestTypeFieldValidator requestTypeFieldForEmailValidator;
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final InternalPortalService internalPortalService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ChannelManager channelManager;
    private final EmailChannelHelper emailChannelHelper;
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskSignupValidator serviceDeskSignupValidator;

    @Autowired
    public EmailSettingsPageDataProvider(RequestTypeInternalService requestTypeInternalService, EmailChannelService emailSettingsService, ServiceDeskNotificationInternalSender serviceDeskNotificationSender, RequestTypeFieldInternalService requestTypeFieldService, RequestTypeFieldValidator requestTypeFieldForEmailValidator, OnBoardingPropertiesService onBoardingPropertiesService, InternalPortalService internalPortalService, ServiceDeskPermissions serviceDeskPermissions, ChannelManager channelManager, EmailChannelHelper emailChannelHelper, ErrorResultHelper errorResultHelper, ServiceDeskSignupValidator serviceDeskSignupValidator) {
        this.requestTypeInternalService = requestTypeInternalService;
        this.emailSettingsService = emailSettingsService;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
        this.requestTypeFieldService = requestTypeFieldService;
        this.requestTypeFieldForEmailValidator = requestTypeFieldForEmailValidator;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.internalPortalService = internalPortalService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.channelManager = channelManager;
        this.emailChannelHelper = emailChannelHelper;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskSignupValidator = serviceDeskSignupValidator;
    }

    public Either<AnError, EmailSettingPageResponse> getData(CheckedUser user, Project project, ServiceDesk serviceDesk, Portal portal, List<EmailChannelSetting> emailChannels, boolean includeServerDetails) {
        boolean expandHelpBubble = this.onBoardingPropertiesService.shouldExpandAdminAgentHelpBubble("local.servicedesk.help.bubble.email.settings.admin.page.shown", user.forJIRA(), serviceDesk);
        if (expandHelpBubble) {
            this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.email.settings.admin.page.shown", user.forJIRA(), serviceDesk);
        }
        return Either.right((Object)EmailSettingPageResponse.builder().setProjectKey(project.getKey()).setPortalKey(this.internalPortalService.getPortalKey(portal)).setCanAdministerJira(this.serviceDeskPermissions.canAdministerJIRA((SDUser)user)).setCanAdministerProject(this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)).setEmailConfigured(!emailChannels.isEmpty()).setOutgoingMailConfigured(this.serviceDeskNotificationSender.isOutgoingMailConfigured()).setIsPublicSignupEnabled(this.serviceDeskSignupValidator.isSignUpSupportedFromPortal(serviceDesk, project)).setCanTurnOnOff(this.emailSettingsService.canTurnOnOrOffEmailChannel(user, project, serviceDesk)).setHasValidRequestType(this.hasValidRequestType(user, project, serviceDesk, portal)).setAddButtonState(this.getAddCustomEmailSettingButtonState()).setIncomingEmails(this.getIncommingEmailsResponse(emailChannels, project, includeServerDetails)).setExpandHelpBubble(expandHelpBubble).build());
    }

    public Either<AnError, EmailSettingDialogResponse> getDetailsDialogData(CheckedUser user, Project project, Portal portal) {
        return Steps.begin((Either)this.requestTypeInternalService.getAllValidRequestTypes(user, project, portal)).then(() -> this.requestTypeFieldService.getAllRequestTypeFieldsForPortalWithoutFieldValues(user, project, portal)).then(this::getEmailSettingDialogResponse).yield((requestTypes, requestTypeFieldInternals, emailSettingDialogResponse) -> emailSettingDialogResponse);
    }

    private Either<AnError, EmailSettingDialogResponse> getEmailSettingDialogResponse(List<RequestType> requestTypes, List<RequestTypeFieldInternal> requestTypeFieldInternals) {
        Map<Integer, List<RequestTypeFieldInternal>> requestTypeToRequestTypeFieldMap = requestTypeFieldInternals.stream().collect(Collectors.groupingBy(RequestTypeFieldInternal::getFormId));
        Map<Boolean, List<RequestType>> map = requestTypes.stream().collect(Collectors.partitioningBy(requestType -> {
            List<RequestTypeFieldInternal> fields = requestTypeToRequestTypeFieldMap.getOrDefault(requestType.getId(), Collections.emptyList());
            return this.requestTypeFieldForEmailValidator.isRequestTypeValidForEmailChannel((RequestType)requestType, fields).isRight();
        }));
        List validRts = map.getOrDefault(true, Collections.emptyList());
        if (validRts.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.email.ondemand.mailbox.creation.failure.no.valid.request.type", new Object[0]).build());
        }
        List invalidRts = map.getOrDefault(false, Collections.emptyList());
        return Either.right((Object)EmailSettingDialogResponse.build(validRts.stream().map(arg_0 -> ((RequestTypeInternalService)this.requestTypeInternalService).toRequestTypeInternal(arg_0)).map(IncomingEmailRequestTypeResponse::build).collect(Collectors.toList()), invalidRts.stream().map(arg_0 -> ((RequestTypeInternalService)this.requestTypeInternalService).toRequestTypeInternal(arg_0)).map(IncomingEmailRequestTypeResponse::build).collect(Collectors.toList())));
    }

    private Boolean hasValidRequestType(CheckedUser user, Project project, ServiceDesk serviceDesk, Portal portal) {
        return this.emailSettingsService.getFirstValidRequestTypeForEmailChannelJava(user, project, portal, serviceDesk).isRight();
    }

    private List<EmailSettingResponse> getIncommingEmailsResponse(List<EmailChannelSetting> emailChannels, Project project, boolean includeServerDetails) {
        return emailChannels.stream().map(channel -> this.getEmailSettingResponse((EmailChannelSetting)channel, project, includeServerDetails)).collect(Collectors.toList());
    }

    public EmailSettingResponse getEmailSettingResponse(EmailChannelSetting setting, Project project, boolean includeServerDetails) {
        io.atlassian.fugue.Option definition = io.atlassian.fugue.Option.none();
        if (includeServerDetails) {
            definition = StepsConverters.newerOption((Option)this.channelManager.getMailChannelByKey(ChannelKey.from((String)setting.getMailChannelKey())));
        }
        Either<AnError, RequestType> requestType = this.emailChannelHelper.requestTypeOf(setting, project);
        return this.getEmailSettingResponse((io.atlassian.fugue.Option<EmailChannelSetting>)io.atlassian.fugue.Option.some((Object)setting), (io.atlassian.fugue.Option<ChannelDefinition>)definition, (io.atlassian.fugue.Option<RequestType>)requestType.toOption());
    }

    public EmailSettingResponse getEmailSettingResponse(EmailChannelScala channel, boolean includeServerDetails) {
        return this.getEmailSettingResponse(channel.getEmailChannelSetting(), includeServerDetails ? channel.getChannelDefinition() : io.atlassian.fugue.Option.none(), (io.atlassian.fugue.Option<RequestType>)io.atlassian.fugue.Option.some((Object)channel.getRequestType()));
    }

    private EmailSettingResponse getEmailSettingResponse(io.atlassian.fugue.Option<EmailChannelSetting> emailChannelSetting, io.atlassian.fugue.Option<ChannelDefinition> channelDefinition, io.atlassian.fugue.Option<RequestType> requestType) {
        EmailSettingResponse.Builder builder = EmailSettingResponse.builder();
        emailChannelSetting.forEach(builder::setFromChannelSettings);
        channelDefinition.forEach(builder::setFromChannelDefenition);
        requestType.forEach(builder::setFromRequestType);
        builder.setBroken(requestType.isEmpty());
        return builder.build();
    }

    private String getAddCustomEmailSettingButtonState() {
        return HIDDEN;
    }
}

