/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.emailchannel;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalServiceScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelService;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailConfiguration;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.rest.emailchannel.EmailSettingsPageDataProvider;
import com.atlassian.servicedesk.internal.rest.requests.IncomingEmailSaveRequest;
import com.atlassian.servicedesk.internal.rest.responses.CheckEmailResponse;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/servicedesk/{projectKey}/incomingemail")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class EmailChannelResource {
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final InternalServiceDeskService serviceDeskService;
    private final RequestTypeInternalServiceScala requestTypeService;
    private final InternalPortalService portalService;
    private final EmailChannelService emailSettingsService;
    private final UserFactory userFactory;
    private final ServiceDeskNotificationInternalSender serviceDeskNotificationSender;
    private final EmailSettingsPageDataProvider emailSettingsPageDataProvider;
    private final RestResponseHelper restResponseHelper;
    private final CommonErrors commonErrors;
    private final EmailChannelSettingService emailChannelSettingService;

    @Autowired
    public EmailChannelResource(ServiceDeskProjectService serviceDeskProjectService, InternalServiceDeskService serviceDeskService, RequestTypeInternalServiceScala requestTypeService, InternalPortalService portalService, EmailChannelService emailSettingsService, UserFactory userFactory, ServiceDeskNotificationInternalSender serviceDeskNotificationSender, EmailSettingsPageDataProvider emailSettingsPageDataProvider, RestResponseHelper restResponseHelper, CommonErrors commonErrors, EmailChannelSettingService emailChannelSettingService) {
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.serviceDeskService = serviceDeskService;
        this.requestTypeService = requestTypeService;
        this.portalService = portalService;
        this.emailSettingsService = emailSettingsService;
        this.userFactory = userFactory;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
        this.emailSettingsPageDataProvider = emailSettingsPageDataProvider;
        this.restResponseHelper = restResponseHelper;
        this.commonErrors = commonErrors;
        this.emailChannelSettingService = emailChannelSettingService;
    }

    @GET
    public Response getEmailSettingsPage(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either response = Steps.begin(this.getBaseData(projectKey)).then(baseData -> this.emailChannelSettingService.getEmailChannelSettings(baseData.getCheckedUser(), baseData.getServiceDesk(), baseData.getProject())).then((baseData, emailChannels) -> this.emailSettingsPageDataProvider.getData(baseData.getCheckedUser(), baseData.getProject(), baseData.getServiceDesk(), baseData.getPortal(), (List<EmailChannelSetting>)emailChannels, true)).yield((baseData, emailChannels, emailSettingPageResponse) -> emailSettingPageResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    @PUT
    @Path(value="turnOff")
    public Response turnOffEmailSettings(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either response = Steps.begin(this.getBaseData(projectKey)).then(baseData -> this.emailChannelSettingService.turnOffEmailChannel(baseData.getCheckedUser(), baseData.getServiceDesk(), baseData.getProject())).then((baseData, success) -> this.emailChannelSettingService.getEmailChannelSettings(baseData.getCheckedUser(), baseData.getServiceDesk(), baseData.getProject())).then((baseData, success, emailChannels) -> this.emailSettingsPageDataProvider.getData(baseData.getCheckedUser(), baseData.getProject(), baseData.getServiceDesk(), baseData.getPortal(), (List<EmailChannelSetting>)emailChannels, false)).yield((baseData, success, emailChannels, emailSettingPageResponse) -> emailSettingPageResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    @DELETE
    @Path(value="/delete/{emailSettingId}")
    public Response removeEmailSetting(@PathParam(value="projectKey") String projectKey, @PathParam(value="emailSettingId") Integer emailSettingId) {
        io.atlassian.fugue.Either response = Steps.begin(this.getBaseData(projectKey)).then(baseData -> this.emailChannelSettingService.removeEmailChannelIfExisting(baseData.getCheckedUser(), baseData.getProject(), baseData.getServiceDesk(), emailSettingId)).then((baseData, success) -> this.emailChannelSettingService.getEmailChannelSettings(baseData.getCheckedUser(), baseData.getServiceDesk(), baseData.getProject())).then((baseData, success, emailChannels) -> this.emailSettingsPageDataProvider.getData(baseData.getCheckedUser(), baseData.getProject(), baseData.getServiceDesk(), baseData.getPortal(), (List<EmailChannelSetting>)emailChannels, false)).yield((baseData, success, emailChannels, emailSettingPageResponse) -> emailSettingPageResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    @GET
    @Path(value="/addincomingemaildialog")
    public Response getAddEmailSettingDialog(@PathParam(value="projectKey") String projectKey, @QueryParam(value="id") String id) {
        io.atlassian.fugue.Either response = Steps.begin(this.getBaseData(projectKey)).then(baseData -> this.emailSettingsPageDataProvider.getDetailsDialogData(baseData.getCheckedUser(), baseData.getProject(), baseData.getPortal())).yield((baseData, emailSettingDialogResponse) -> emailSettingDialogResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    @POST
    @Path(value="/validateemailforcreation")
    public Response validateEmailSettingsForCreation(@PathParam(value="projectKey") String projectKey, IncomingEmailSaveRequest req) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.emailSettingsService.validateEmailConfiguration((CheckedUser)user, (Project)project, EmailConfiguration.from(req), (Option<EmailChannelSetting>)Option.none())).yield((user, project, isInboxEmpty) -> isInboxEmpty);
        return this.restResponseHelper.anErrorEitherToOkResponse(result.map(isInboxEmpty -> new CheckEmailResponse(true, (boolean)isInboxEmpty)));
    }

    @POST
    @Path(value="/validateemailforupdate")
    public Response validateEmailSettingsForUpdate(@PathParam(value="projectKey") String projectKey, IncomingEmailSaveRequest req) {
        io.atlassian.fugue.Either result = Steps.begin(this.getBaseData(projectKey)).then(baseData -> req.getId().toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_INVALID())).then((baseData, channelId) -> this.emailChannelSettingService.getEmailChannelById(baseData.getCheckedUser(), baseData.getProject(), baseData.getServiceDesk(), (Integer)channelId)).then((baseData, project, emailChannel) -> this.emailSettingsService.validateEmailConfiguration(baseData.getCheckedUser(), baseData.getProject(), EmailConfiguration.from(req), (Option<EmailChannelSetting>)Option.some((Object)emailChannel))).yield((baseData, project, emailChannel, isInboxEmpty) -> isInboxEmpty);
        return this.restResponseHelper.anErrorEitherToOkResponse(result.map(isInboxEmpty -> new CheckEmailResponse(true, (boolean)isInboxEmpty)));
    }

    @PUT
    @Path(value="/new")
    public Response addEmailSetting(@PathParam(value="projectKey") String projectKey, IncomingEmailSaveRequest req) {
        io.atlassian.fugue.Either response = Steps.begin(this.getBaseData(projectKey)).then(baseData -> this.getRequestTypeById(baseData.getCheckedUser(), baseData.getProject(), req.getRequestTypeId())).then((baseData, requestType) -> this.emailSettingsService.createEmailChannel(baseData.getCheckedUser(), baseData.getProject(), baseData.getServiceDesk(), (RequestType)requestType, EmailConfiguration.from(req))).yield((baseData, requestType, emailChannel) -> {
            this.serviceDeskNotificationSender.sendTestEmail(baseData.getCheckedUser(), emailChannel.emailAddress(), false, baseData.getProject());
            return this.emailSettingsPageDataProvider.getEmailSettingResponse((EmailChannelScala)emailChannel, false);
        });
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    @PUT
    @Path(value="/update")
    public Response updateEmailSetting(@PathParam(value="projectKey") String projectKey, IncomingEmailSaveRequest req) {
        io.atlassian.fugue.Either response = Steps.begin(this.getBaseData(projectKey)).then(baseData -> this.getRequestTypeById(baseData.getCheckedUser(), baseData.getProject(), req.getRequestTypeId())).then((baseData, requestType) -> req.getId().toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_INVALID())).then((baseData, requestType, channelId) -> this.emailChannelSettingService.getEmailChannelById(baseData.getCheckedUser(), baseData.getProject(), baseData.getServiceDesk(), (Integer)channelId)).then((baseData, requestType, channelId, emailChannel) -> this.emailSettingsService.updateEmailChannel(baseData.getCheckedUser(), baseData.getServiceDesk(), baseData.getProject(), (RequestType)requestType, (EmailChannelSetting)emailChannel, EmailConfiguration.from(req))).yield((baseData, requestType, channelId, emailChannel, updatedEmailChannel) -> {
            if (!updatedEmailChannel.getEmailAddress().equals(emailChannel.getEmailAddress())) {
                this.serviceDeskNotificationSender.sendTestEmail(baseData.getCheckedUser(), updatedEmailChannel.getEmailAddress(), true, baseData.getProject());
            }
            return this.emailSettingsPageDataProvider.getEmailSettingResponse((EmailChannelSetting)updatedEmailChannel, baseData.getProject(), true);
        });
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    private io.atlassian.fugue.Either<AnError, BaseData> getBaseData(String projectKey) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.serviceDeskService.getServiceDeskForProject(user, project, false)).then((user, project, serviceDesk) -> this.portalService.getPortalByProject((CheckedUser)user, (Project)project)).yield((x$0, x$1, x$2, x$3) -> new BaseData((CheckedUser)x$0, (Project)x$1, (ServiceDesk)x$2, (Portal)x$3));
    }

    private io.atlassian.fugue.Either<AnError, RequestType> getRequestTypeById(CheckedUser user, Project project, Option<Integer> requestTypeId) {
        return Steps.begin((io.atlassian.fugue.Either)requestTypeId.toRight(() -> ((CommonErrors)this.commonErrors).REQUEST_TYPE_NOT_FOUND())).then(nonNullRequestTypeId -> this.requestTypeService.getRequestTypeById(user, (int)nonNullRequestTypeId, project)).yield((nonNullRequestTypeId, requestType) -> requestType);
    }

    private class BaseData {
        private CheckedUser checkedUser;
        private Project project;
        private ServiceDesk serviceDesk;
        private Portal portal;

        BaseData(CheckedUser checkedUser, Project project, ServiceDesk serviceDesk, Portal portal) {
            this.checkedUser = checkedUser;
            this.project = project;
            this.serviceDesk = serviceDesk;
            this.portal = portal;
        }

        public CheckedUser getCheckedUser() {
            return this.checkedUser;
        }

        public Project getProject() {
            return this.project;
        }

        public ServiceDesk getServiceDesk() {
            return this.serviceDesk;
        }

        public Portal getPortal() {
            return this.portal;
        }
    }
}

